% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{excess_probability.EQRN_iid}
\alias{excess_probability.EQRN_iid}
\title{Tail excess probability prediction method using an EQRN_iid object}
\usage{
\method{excess_probability}{EQRN_iid}(object, ...)
}
\arguments{
\item{object}{Fitted \code{"EQRN_iid"} object.}

\item{...}{
  Arguments passed on to \code{\link[=EQRN_excess_probability]{EQRN_excess_probability}}
  \describe{
    \item{\code{val}}{Quantile value(s) used to estimate the conditional excess probability or cdf.}
    \item{\code{X}}{Matrix of covariates to predict the corresponding response's conditional excess probabilities.}
    \item{\code{intermediate_quantiles}}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}
    \item{\code{interm_lvl}}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}
    \item{\code{body_proba}}{Value to use when the predicted conditional probability is below \code{interm_lvl}
(in which case it cannot be precisely assessed by the model).
If \code{"default"} is given (the default), \code{paste0(">",1-interm_lvl)} is used if \code{proba_type=="excess"},
and \code{paste0("<",interm_lvl)} is used if \code{proba_type=="cdf"}.}
    \item{\code{proba_type}}{Whether to return the \code{"excess"} probability over \code{val} (default) or the \code{"cdf"} at \code{val}.}
    \item{\code{device}}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
  }}
}
\value{
Vector of probabilities (and possibly a few \code{body_proba} values if \code{val} is not large enough) of length \code{nrow(X)}.
}
\description{
Tail excess probability prediction method using an EQRN_iid object
}
\details{
See \code{\link[=EQRN_excess_probability]{EQRN_excess_probability()}} for more details.
}
