% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/known.graph.R
\name{known.graph}
\alias{known.graph}
\title{Re-fit Network}
\usage{
known.graph(S, A, method = c("glasso", "HTF"), tol = 0.000001, max.iter = 100)
}
\arguments{
\item{S}{Matrix.
Covariance or correlation matrix}

\item{A}{Adjacency matrix.
Unweighted network structure where \code{1} is an edge present
and \code{0} is an edge absent}

\item{method}{Character (length = 1).
Whether to use the \code{\link[glasso]{glasso}} method without
penalization or the HTF (Haste, Tibshirani, & Friedman, 2008) method.
Defaults to \code{"glasso"}, which tends to be more robust}

\item{tol}{Numeric (length = 1).
Tolerance for convergence. The algorithm stops when the maximum
absolute change in covariance matrix elements between iterations
is less than \code{tol}. Defaults to \code{1e-06}}

\item{max.iter}{Numeric (length = 100).
Maximum number of iterations to achieve tolerance before stopping}
}
\value{
Returns a list containing:

\item{network}{Estimated network}

\item{W}{Estimated covariance matrix}

\item{Theta}{Estimated inverse covariance matrix}

\item{iterations}{Number of iterations to converge (or maximum if it did not)}

\item{converged}{Whether the algorithm converged}
}
\description{
Refits a network with unregularized partial correlations
based on some known graph (perhaps estimated with a regularization method)
following Hastie, Tibshirani, and Friedman (2008)
}
\examples{
# Obtain data
wmt <- depression[,24:44]

# Obtain correlation matrix
wmt_R <- auto.correlate(wmt)

# Estimate network
wmt_network <- network.estimation(wmt_R, n = nrow(wmt))

# Obtain adjacency
wmt_A <- wmt_network
wmt_A[] <- ifelse(wmt_A != 0, 1, 0)

# Obtain unregularized estimate
wmt_unreg <- known.graph(S = wmt_R, A = wmt_A)

}
\references{
\strong{HTF Implementation on p. 631--634} \cr
Hastie, T., Tibshirani, R., & Friedman, J. (2008).
The elements of statistical learning: Data mining, inference, and prediction (2nd ed.).
New York, NY: Springer.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>,
}
