\name{rastrigin}
\alias{rastrigin}
\title{Rastrigin function for optimization problems}

\usage{
rastrigin(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Rastrigin function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Rastrigin function at the input vector \code{x}.
}

\description{
The Rastrigin function is a standard benchmark function used for testing optimization algorithms. It is a non-convex function with a global minimum at the origin. Although it can be defined in any number of dimensions, it is commonly evaluated in 4 dimensions in this documentation. Note that the typical search domain for the Rastrigin function is \code{[-5.12, 5.12]}, which is used for visualization purposes.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
rastrigin(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
rastrigin(x)

# Contour Plot: Visualizing the Rastrigin Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) rastrigin(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Rastrigin Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = rastrigin, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) rastrigin(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Rastrigin Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}


\references{
Rastrigin, L. A. (1974). Systems of extremal control. Mir.
}
