\name{cigar}
\alias{cigar}
\title{Cigar function for optimization problems}

\usage{
cigar(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Cigar function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Cigar function at the input vector \code{x}.
}

\description{
The Cigar function is a test function in optimization characterized by a narrow, elongated valley. This function is useful for testing the performance of optimization algorithms in situations where the minimum is located in a flat region with a high condition number, making it difficult for algorithms to converge efficiently.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
cigar(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
cigar(x)

# Contour Plot: Visualizing the Cigar Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) cigar(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Cigar Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = cigar, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) cigar(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Cigar Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Hansen, N., Müller, S. D., & Koumoutsakos, P. (2003). \emph{Reducing the time complexity of the derandomized evolution strategy with covariance matrix adaptation (CMA-ES)}. Evolutionary Computation, 11(1), 1-18.}
}
