\name{ExplicitExploration}
\alias{ExplicitExploration}
\title{Explicit exploration in evolutionary algorithms}
\usage{
ExplicitExploration(
  fun,
  lower,
  upper,
  n = 30,
  maxiter,
  k = 5,
 tolerance = 0.01,
 ...
)
}
\arguments{
\item{fun}{
  A function to be minimized, with first argument the vector of parameters over which minimization is to take place.
  }

\item{lower}{
    Lower bounds on the parameters.
  }
\item{upper}{
    Upper bounds on the parameters.
  }
\item{n}{Number of individuals per generation}

\item{maxiter}{Maximum number of iterations.}

\item{k}{Number of consecutive generations without change in distribution before stopping.}

\item{tolerance}{Criterion for determining whether the distribution has changed.}

\item{...}{Additional arguments of the objective function.}

}


\value{
Returns a list with the following entries:
\item{\code{par}}{The top n individuals from the entire search.}
\item{\code{Y}}{The value of the objective function for each of the best individuals.}
\item{\code{n_gen}}{Number of generations required for the search.}
\item{\code{par_historical}}{All individuals generated during the search.}
\item{\code{historical}}{The value of the objective function for all generated individuals.}
}

\description{
It makes an explicit exploration as proposed in Salinas-Gutiérrez and Zavala, 2023.
}

\examples{

fun <- function(X){
  D <- length(X)
  f <- abs(sum(X^2) - D)^(1/4) + (0.5 * sum(X^2) + sum(X))/D + 0.5
  return(f)
}

n <- 30
k <- 2
tolerance <- 0.01
lower <- c(-5,-5)
upper <- c(5,5)
res <- ExplicitExploration(fun, lower = lower,
                           upper = upper,n = n,
                           maxiter = 20,
                           k = k)

z <- outer(X = seq(-5, 5, 0.05), Y = seq(-5, 5, 0.05),
           FUN = Vectorize(function(X, Y) { fun(c(X, Y)) }))

contour(seq(-5, 5, 0.05),seq(-5, 5, 0.05),z,
        nlevels = 20, cex.axis = .8)
points(res$par_historical[,1],res$par_historical[,2],
       col = "blue")
points(res$par[,1],res$par[,2], col = "red",
       pch = 19)

}

\references{
{ Salinas-Gutiérrez, R., & Zavala, A. E. M. (2023).An explicit exploration strategy for
 evolutionary algorithms. Applied Soft Computing, 140.
 https://doi.org/10.1016/j.asoc.2023.110230}
}


