% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_common_cols}
\alias{get_common_cols}
\alias{summary.common_cols}
\title{Get columns that are common to multiple datasets}
\usage{
get_common_cols(lookup = edc_lookup(), min_datasets = 3)

\method{summary}{common_cols}(object, ...)
}
\arguments{
\item{lookup}{the lookup table, default to \code{\link[=edc_lookup]{edc_lookup()}}}

\item{min_datasets}{the minimal number of datasets to be considered}

\item{object}{an object of class "common_cols"}

\item{...}{unused}
}
\value{
a tibble of class "common_cols"
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Attempt to list all columns in the database and group the ones that are
common to some datasets.
Useful to find keys to pivot or summarise data.
}
\examples{
db = edc_example()
load_database(db)
x = get_common_cols(min_datasets=1)
x
summary(x)
}
