% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patient_gridplot.R
\name{edc_patient_gridplot}
\alias{edc_patient_gridplot}
\title{Patient gridplot}
\usage{
edc_patient_gridplot(
  sort_rows = TRUE,
  sort_cols = TRUE,
  gradient = FALSE,
  axes_flip = FALSE,
  show_grid = TRUE,
  preprocess = NULL,
  palette = c(Yes = "#00468BFF", No = "#ED0000FF"),
  datasets = get_datasets(),
  lookup = edc_lookup()
)
}
\arguments{
\item{sort_rows}{whether to sort patients from "present in most datasets" to "present in least datasets"}

\item{sort_cols}{whether to sort datasets from "containing the most patients" to "containing the least patients"}

\item{gradient}{whether to add a color gradient for repeating measures}

\item{axes_flip}{whether to flip the axes, so that patients are on the Y axis and datasets on the X axis}

\item{show_grid}{whether to show the grid}

\item{preprocess}{a function to preprocess the patient ID, e.g. \code{as.numeric}, or a custom function with string replacement}

\item{palette}{the colors to use}

\item{datasets, lookup}{internal}
}
\value{
a \code{ggplot} object
}
\description{
Draw a gridplot giving, for each patient and each dataset, whether the
patient is present in the dataset. Data are drawn from \link{get_datasets}.
}
\examples{
\dontrun{
  tm = read_trialmaster("path/to/archive.zip")
  load_database(db)
  edc_patient_gridplot(sort_rows=FALSE, sort_cols=FALSE)
  edc_patient_gridplot(axes_flip=TRUE, show_grid=TRUE,
                       preprocess=~str_remove(.x, "\\\\D*")) #remove all non-digits
}
}
