% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_PLS.R
\name{density_PLS}
\alias{density_PLS}
\title{Penalized least-squares method in Du and Hu (2022)}
\usage{
density_PLS(x, qq)
}
\arguments{
\item{x}{a sequence of chi-squared test statistics}

\item{qq}{the quantiles used for splines}
}
\value{
a list: the first and second density derivatives
}
\description{
The semiparametric model is employed to estimate the log density derivatives of
the chi-squared statistics.
}
\examples{
p = 1000
k = 7
# the prior distribution for lambda
alpha = 2
beta =  10
# lambda
lambda = rep(0, p)
pi_0 = 0.5
p_0 = floor(p*pi_0)
p_1 = p-p_0
lambda[(p_0+1):p] = stats::rgamma(p_1, shape = alpha, rate=1/beta)
# Generate a Poisson RV
J = sapply(1:p, function(x){rpois(1, lambda[x]/2)})
X = sapply(1:p, function(x){rchisq(1, k+2*J[x])})
qq = c(0.2, 0.4, 0.6, 0.8)
out = density_PLS(X, qq)

}
