% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_models.R
\name{run_models}
\alias{run_models}
\title{Run multiple \bold{existing} \code{mod} or \code{dyn} files.}
\usage{
run_models(model = "*", import_log = FALSE)
}
\arguments{
\item{model}{Object or a  vector of character strings representing the names of the \code{Dynare} model files excluding \code{.mod} or \code{.dyn} file extension}

\item{import_log}{Logical. Whether or not to import \code{dynare} log file.}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) outputs
}
\description{
Use this function to execute multiple \bold{existing} \code{Dynare} files.
Use \code{run_models(model='someModel')}  if the Dynare files live in the current working directory.
Use \code{run_models(model='someDirectory/someModel')}  if the Dynare files live in the path different from the current working directory (for example, \code{someDirectory}).
}
\examples{
library(DynareR)

\dontrun{
demo(agtrend)
demo(bkk)
demo(example1)

# Provide the list of the `Dynare` files in a vector
# Ensure that "agtrend.mod", "bkk.mod" and "example1.mod"
# live in the current working directory

# Copy the dynare files to the current working directory

lapply(c("agtrend","bkk","example1"),\(x) file.copy(paste0(x,"/",x,".mod"),"."))

run_models(c("agtrend","bkk","example1")) # Run the models in the vector.

run_models() # Run all models in Current Working Directory.

# You can run all models that live in "DynareR/run_dynare/" folder

# Copy the dynare files to the 'DynareR/run_dynare' directory

lapply(c("agtrend","bkk","example1"),\(x) file.copy(paste0(x,".mod"),"DynareR/run_dynare"))

run_models("DynareR/run_dynare*") # Note the * at the end.
}
}
\seealso{
Other important functions: 
\code{\link{DynareR-package}},
\code{\link{add_matlab_path}()},
\code{\link{add_path}()},
\code{\link{eng_dynare}()},
\code{\link{import_log}()},
\code{\link{include_IRF}()},
\code{\link{input_tex}()},
\code{\link{run_dynare}()},
\code{\link{set_dynare_version}()},
\code{\link{set_matlab_path}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\concept{important functions}
\keyword{documentation}
