% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{correlation_matrices_example}
\alias{correlation_matrices_example}
\title{Correlation matrices}
\format{
A named list with 2 items.
\describe{
  \item{correlation_matrices}{A named list with two groups.}
  \describe{
    \item{groupA}{Correlation matrices associated with `groupA`}
    \describe{
    \item{mrna}{Correlation matrix}
    \item{protein}{Correlation matrix}
    \item{phosphosite}{Correlation matrix}
    \item{metabolite}{Correlation matrix}
    }
    \item{groupB}{same structure as `groupA`}
    }
  \item{annotations}{A named list containing dataframes of mappings of assigned node IDs to the
  user-provided component identifiers for nodes in `groupA` or `groupB` and all nodes}
  \describe{
  \item{groupA}{Annotations associated with `groupA`}
    \describe{
    \item{mrna}{Dataframe}
    \item{protein}{Dataframe}
    \item{phosphosite}{Dataframe}
    \item{metabolite}{Dataframe}
    }
  \item{groupB}{same structure as `groupA`}
  \item{both}{same structure as `groupA`}
  }
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and
Targeted Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
correlation_matrices_example
}
\description{
Exemplary intermediate pipeline output: Correlation matrices example data built by
\code{\link[DrDimont]{compute_correlation_matrices}} using \link[DrDimont]{layers_example}
data and settings:
}
\details{
\code{settings <- drdimont_settings(
                         handling_missing_data=list(
                             default="pairwise.complete.obs",
                             mrna="all.obs"))}

A subset of the original data from Krug et al. (2020) and randomly sampled metabolite
data in \link[DrDimont]{layers_example} was used to generate the correlation
matrices. They were created from data stratified by estrogen receptor (ER) status:
`groupA` contains data of ER+ patients and `groupB` of ER- patients.
}
\keyword{datasets}
