% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-summary.R
\name{DiscreteTestResultsSummary}
\alias{DiscreteTestResultsSummary}
\title{Discrete Test Results Summary Class}
\description{
This is the class used by \code{DiscreteTests} for summarising
\code{\link{DiscreteTestResults}} objects. It contains the summarised objects itself,
as well as a summary \code{\link[tibble:tibble]{tibble}} object as private members.
Both can be extracted by public methods.
}
\examples{
# binomial tests
obj <- binom_test_pv(0:5, 5, 0.5)
# create DiscreteTestResultsSummary object
res <- DiscreteTestResultsSummary$new(obj)
# print summary
print(res)
# extract summary table
res$get_summary_table()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-summary.DiscreteTestResults-new}{\code{DiscreteTestResultsSummary$new()}}
\item \href{#method-summary.DiscreteTestResults-get_test_results}{\code{DiscreteTestResultsSummary$get_test_results()}}
\item \href{#method-summary.DiscreteTestResults-get_summary_table}{\code{DiscreteTestResultsSummary$get_summary_table()}}
\item \href{#method-summary.DiscreteTestResults-print}{\code{DiscreteTestResultsSummary$print()}}
\item \href{#method-summary.DiscreteTestResults-clone}{\code{DiscreteTestResultsSummary$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary.DiscreteTestResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-summary.DiscreteTestResults-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{summary.DiscreteTestResults} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiscreteTestResultsSummary$new(test_results)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{test_results}}{the \code{\link{DiscreteTestResults}} class object to be
summarised.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary.DiscreteTestResults-get_test_results"></a>}}
\if{latex}{\out{\hypertarget{method-summary.DiscreteTestResults-get_test_results}{}}}
\subsection{Method \code{get_test_results()}}{
Returns the underlying \link{DiscreteTestResults} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiscreteTestResultsSummary$get_test_results()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{DiscreteTestResults} R6 class object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary.DiscreteTestResults-get_summary_table"></a>}}
\if{latex}{\out{\hypertarget{method-summary.DiscreteTestResults-get_summary_table}{}}}
\subsection{Method \code{get_summary_table()}}{
Returns the summary table of the underlying \link{DiscreteTestResults} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiscreteTestResultsSummary$get_summary_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary.DiscreteTestResults-print"></a>}}
\if{latex}{\out{\hypertarget{method-summary.DiscreteTestResults-print}{}}}
\subsection{Method \code{print()}}{
Prints the summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiscreteTestResultsSummary$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments passed to \code{print.data.frame}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Prints a summary table of the tested null hypotheses. The object itself
is invisibly returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary.DiscreteTestResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-summary.DiscreteTestResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiscreteTestResultsSummary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
