% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{plot.DiscreteFWER}
\alias{plot.DiscreteFWER}
\title{Plot Method for \code{DiscreteFWER} objects}
\usage{
\method{plot}{DiscreteFWER}(
  x,
  col = c(2, 4, 1),
  pch = c(20, 20, 17),
  lwd = rep(par()$lwd, 3),
  cex = rep(par()$cex, 3),
  type_crit = "b",
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{DiscreteFWER}.}

\item{col}{numeric or character vector of length 3 indicating the
colours of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}}

\item{pch}{numeric or character vector of length 3 indicating the
point characters of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present and \code{type_crit}
is a plot type like \code{'p'}, \code{'b'} etc.).
}}

\item{lwd}{numeric vector of length 3 indicating the thickness of the
points and lines; defaults to current \code{par()$lwd} setting.}

\item{cex}{numeric vector of length 3 indicating the size of point
characters or lines of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}
defaults to current \code{par()$cex} setting.}

\item{type_crit}{1-character string giving the type of plot desired for the
critical values (e.g.: \code{'p'}, \code{'l'} etc; see \code{\link[=plot]{plot()}}).}

\item{legend}{if \code{NULL}, no legend is plotted; otherwise expecting a
character string like \code{"topleft"} etc. or a numeric vector
of two elements indicating (x, y) coordinates.}

\item{...}{further arguments to \code{\link[=plot.default]{plot.default()}}.}
}
\value{
A plot is created, but no value is returned.
}
\description{
Plots raw p-values of a \code{DiscreteFWER} object and highlights rejected and
accepted p-values. If calculated, the critical values are plotted, too.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Computation of p-values and their supports with Fisher's exact test
library(DiscreteTests)  # for Fisher's exact test
test_results <- fisher_test_pv(df)
raw_pvalues <- test_results$get_pvalues()
pCDFlist <- test_results$get_pvalue_supports()

DBonf_fast <- DBonferroni(raw_pvalues, pCDFlist)
DBonf_crit <- DBonferroni(test_results, critical_values = TRUE)
DHolm_fast <- DHolm(test_results)
DHolm_crit <- DHolm(raw_pvalues, pCDFlist, critical_values = TRUE)

plot(DBonf_fast)
plot(DBonf_crit, xlim = c(1, 5), ylim = c(0, 0.4))
plot(DHolm_fast, col = c(2, 4), pch = c(2, 3), lwd = c(2, 2), 
     legend = "topleft", xlim = c(1, 5), ylim = c(0, 0.4))
plot(DHolm_crit, col = c(2, 4, 1), pch = c(1, 1, 4), lwd = c(1, 1, 2), 
     type_crit = 'o', legend = c(1, 0.4), lty = 1, xlim = c(1, 5), 
     ylim = c(0, 0.4))

}
