% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{hist.DiscreteFWER}
\alias{hist.DiscreteFWER}
\title{Histogram of Raw P-Values}
\usage{
\method{hist}{DiscreteFWER}(x, breaks = "FD", mode = c("raw", "selected"), ...)
}
\arguments{
\item{x}{an object of class \code{DiscreteFWER}.}

\item{breaks}{as in \code{\link[graphics:hist]{graphics::hist()}}; here, the Friedman-Diaconis
algorithm (\code{"FD"}) is used as default.}

\item{mode}{single character string specifying for which $p$-values the
histogram is to be generated; must either be \code{"raw"} or
\code{"selected"}.}

\item{...}{further arguments to \code{\link[graphics:hist]{graphics::hist()}} or
\code{\link[graphics:plothistogram]{graphics::plot.histogram()}}, respectively.}
}
\value{
An object of class \code{histogram}.
}
\description{
Computes a histogram of the raw p-values of a \code{DiscreteFWER} object.
}
\details{
If \code{x} does not contain results of a selection approach, a warning is issued
and a histogram of the raw p-values is drawn.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Computation of p-values and their supports with Fisher's exact test
library(DiscreteTests)  # for Fisher's exact test
test_results <- fisher_test_pv(df)
raw_pvalues <- test_results$get_pvalues()
pCDFlist <- test_results$get_pvalue_supports()

# d-Holm with critical values; using test results object
DHolm_crit <- DHolm(test_results, critical_values = TRUE)
hist(DHolm_crit)

}
