create_sentiment_map <- function(data, lat_col = "Latitude", lon_col = "Longitude") {
  
  if (!requireNamespace("leaflet", quietly = TRUE)) {
    stop("Package leaflet is required but not installed.")
  }
  
  # Create color palette
  getColor <- function(sentiment) {
    sapply(sentiment, function(x) {
      if (x == "Positive") {
        "green"
      } else if (x == "Negative") {
        "red"
      } else {
        "blue"
      }
    })
  }
  
  # Create popup text
  popup_text <- paste(
    "<b>Location:</b>", data$City, "<br>",
    "<b>Sentiment:</b>", data$sentiment_category, 
    "(", round(data$sentiment_score, 2), ")", "<br>",
    "<b>Comment:</b>", substr(data$User_Comment, 1, 100), "..."
  )
  
  # Create map
  map <- leaflet::leaflet(data) %>%
    leaflet::addTiles() %>%
    leaflet::setView(lng = 24.5, lat = -28.5, zoom = 6) %>%
    leaflet::addCircleMarkers(
      lng = data[[lon_col]],
      lat = data[[lat_col]],
      color = getColor(data$sentiment_category),
      radius = 8,
      popup = popup_text,
      stroke = TRUE,
      fillOpacity = 0.7
    )
  
  return(map)
}