% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filledcontourview.R
\name{filledcontourview.function}
\alias{filledcontourview.function}
\alias{filledcontourview,function,function-method}
\alias{filledcontourview.km}
\alias{filledcontourview,km,km-method}
\alias{filledcontourview.Kriging}
\alias{filledcontourview,Kriging,Kriging-method}
\alias{filledcontourview.NuggetKriging}
\alias{filledcontourview,NuggetKriging,NuggetKriging-method}
\alias{filledcontourview.NoiseKriging}
\alias{filledcontourview,NoiseKriging,NoiseKriging-method}
\alias{filledcontourview.glm}
\alias{filledcontourview,glm,glm-method}
\alias{filledcontourview.list}
\alias{filledcontourview,list,list-method}
\alias{filledcontourview}
\title{Plot a contour view of a prediction model or function, including design points if available.}
\usage{
\method{filledcontourview}{`function`}(
  fun,
  vectorized = FALSE,
  center = NULL,
  lty_center = 2,
  col_center = "black",
  axis = NULL,
  npoints = 21,
  levels = 10,
  lty_levels = 0,
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  col_interval = "white",
  col_fading_interval = 0.5,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = if (!add) matrix(c(0, 1), 2, 2) else NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  add_fading = 0.5,
  ...
)

\method{filledcontourview}{km}(
  km_model,
  type = "UK",
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(c(km_model@y + 2 * sqrt(km_model@covariance@sd2), km_model@y - 2 *
    sqrt(km_model@covariance@sd2)), 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  conf_level = 0.5,
  conf_fading = 0.5,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

\method{filledcontourview}{Kriging}(
  Kriging_model,
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(Kriging_model$y(), 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  conf_level = 0.5,
  conf_fading = 0.5,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

\method{filledcontourview}{NuggetKriging}(
  NuggetKriging_model,
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(NuggetKriging_model$y(), 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  conf_level = 0.5,
  conf_fading = 0.5,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

\method{filledcontourview}{NoiseKriging}(
  NoiseKriging_model,
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(NoiseKriging_model$y(), 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  conf_level = 0.5,
  conf_fading = 0.5,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

\method{filledcontourview}{glm}(
  glm_model,
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(glm_model$fitted.values, 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  conf_level = 0.5,
  conf_fading = 0.5,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

\method{filledcontourview}{list}(
  modelFit_model,
  center = NULL,
  axis = NULL,
  npoints = 21,
  levels = pretty(modelFit_model$data$Y, 10),
  col_points = if (!is.null(col) & length(col) == 1) col else "red",
  col_levels = if (!is.null(col) & length(col) == 1) col.levels(col, levels, fill = TRUE)
    else if (!is.null(col) & length(col) == 2) cols.levels(col[1], col[2], levels, fill =
    TRUE) else col.levels("blue", levels, fill = TRUE),
  col = NULL,
  bg_fading = 1,
  mfrow = NULL,
  Xlab = NULL,
  ylab = NULL,
  Xlim = NULL,
  ylim = NULL,
  title = NULL,
  title_sep = " | ",
  add = FALSE,
  ...
)

filledcontourview(...)
}
\arguments{
\item{fun}{a function or 'predict()'-like function that returns a simple numeric or mean and standard error: list(mean=...,se=...).}

\item{vectorized}{is fun vectorized?}

\item{center}{optional coordinates (as a list or data frame) of the center of the section view if the model's dimension is > 2.}

\item{lty_center}{line type for thesection center of the plot (if any).}

\item{col_center}{color for the section center of the plot (if any).}

\item{axis}{optional matrix of 2-axis combinations to plot, one by row. The value \code{NULL} leads to all possible combinations i.e. \code{choose(D, 2)}.}

\item{npoints}{an optional number of points to discretize plot of response  surface and uncertainties.}

\item{levels}{(number of) contour levels to display.}

\item{lty_levels}{contour line type.}

\item{col_levels}{color for the surface.}

\item{col}{color of the object (use col_* for specific objects).}

\item{col_interval}{color to display interval width.}

\item{col_fading_interval}{an optional factor of alpha (color channel) fading used to plot function output intervals (if any).}

\item{mfrow}{an optional list to force \code{par(mfrow = ...)} call. The default value  \code{NULL} is automatically set for compact view.}

\item{Xlab}{an optional list of string to overload names for X.}

\item{ylab}{an optional string to overload name for y.}

\item{Xlim}{an optional list to force x range for all plots. The default value \code{NULL} is automatically set to include all design points.}

\item{ylim}{an optional list to force y range for all plots.}

\item{title}{an optional overload of main title.}

\item{title_sep}{customize subtitle with fixed input.}

\item{add}{to print graphics on an existing window.}

\item{add_fading}{an optional factor of alpha (color channel) fading used to plot when add=TRUE.}

\item{...}{arguments of the \code{filledcontourview.km}, \code{filledcontourview.glm}, \code{filledcontourview.Kriging} or \code{filledcontourview.function} function}

\item{km_model}{an object of class \code{"km"}.}

\item{type}{the kriging type to use for model prediction.}

\item{col_points}{color of points.}

\item{conf_level}{confidence hulls to display.}

\item{conf_fading}{an optional factor of alpha (color channel) fading used to plot confidence hull.}

\item{bg_fading}{an optional factor of alpha (color channel) fading used to plot design points outside from this section.}

\item{Kriging_model}{an object of class \code{"Kriging"}.}

\item{NuggetKriging_model}{an object of class \code{"Kriging"}.}

\item{NoiseKriging_model}{an object of class \code{"Kriging"}.}

\item{glm_model}{an object of class \code{"glm"}.}

\item{modelFit_model}{an object returned by DiceEval::modelFit.}
}
\description{
Plot a contour view of a prediction model or function, including design points if available.
}
\details{
If available, experimental points are plotted with fading colors. Points that fall in the specified section (if any) have the color specified \code{col_points} while points far away from the center have shaded versions of the same color. The amount of fading is determined using the Euclidean distance between the plotted point and \code{center}.
}
\examples{
x1 <- rnorm(15)
x2 <- rnorm(15)

y <- x1 + x2 + rnorm(15)
model <- lm(y ~ x1 + x2)

filledcontourview(function(x) sum(x),
                     Xlim=cbind(range(x1),range(x2)), col='black')
points(x1,x2)

filledcontourview(function(x) {
                      x = as.data.frame(x)
                      colnames(x) <- all.vars(model$call)[-1]
                      predict.lm(model, newdata=x, se.fit=FALSE)
                    }, vectorized=TRUE, dim=2,
                  Xlim=cbind(range(x1),range(x2)), add=TRUE)

if (requireNamespace("DiceKriging")) { library(DiceKriging)

X = matrix(runif(15*2),ncol=2)
y = apply(X,1,branin)

model <- km(design = X, response = y, covtype="matern3_2")

filledcontourview(model)

}

if (requireNamespace("rlibkriging")) { library(rlibkriging)

X = matrix(runif(15*2),ncol=2)
y = apply(X,1,branin)

model <- Kriging(X = X, y = y, kernel="matern3_2")

filledcontourview(model)

}

if (requireNamespace("rlibkriging")) { library(rlibkriging)

X = matrix(runif(15*2),ncol=2)
y = apply(X,1,branin) + 5*rnorm(15)

model <- NuggetKriging(X = X, y = y, kernel="matern3_2")

filledcontourview(model)

}

if (requireNamespace("rlibkriging")) { library(rlibkriging)

X = matrix(runif(15*2),ncol=2)
y = apply(X,1,branin) + 5*rnorm(15)

model <- NoiseKriging(X = X, y = y, kernel="matern3_2", noise=rep(5^2,15))

filledcontourview(model)

}

x1 <- rnorm(15)
x2 <- rnorm(15)

y <- x1 + x2^2 + rnorm(15)
model <- glm(y ~ x1 + I(x2^2))

filledcontourview(model)

if (requireNamespace("DiceEval")) { library(DiceEval)

X = matrix(runif(15*2),ncol=2)
y = apply(X,1,branin)

model <- modelFit(X, y, type = "StepLinear")

filledcontourview(model)

}

## A 2D example - Branin-Hoo function
filledcontourview(branin, levels=30, col='black')

\dontrun{
## a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- expand.grid(seq(0, 1, length = 4), seq(0, 1, length = 4))
design.fact <- data.frame(design.fact); names(design.fact) <- c("x1", "x2")
y <- branin(design.fact); names(y) <- "y"

if (requireNamespace("DiceKriging")) { library(DiceKriging)
## model: km
model <- DiceKriging::km(design = design.fact, response = y)
filledcontourview(model, levels=30)
filledcontourview(branin, levels=30, col='red', add=TRUE)
}

if (requireNamespace("rlibkriging")) { library(rlibkriging)
## model: Kriging
model <- Kriging(X = as.matrix(design.fact), y = as.matrix(y), kernel="matern3_2")
filledcontourview(model, levels=30)
filledcontourview(branin, levels=30, col='red', add=TRUE)
}

## model: glm
model <- glm(y ~ 1+ x1 + x2 + I(x1^2) + I(x2^2) + x1*x2, data=cbind(y,design.fact))
filledcontourview(model, levels=30)
filledcontourview(branin, levels=30, col='red', add=TRUE)

if (requireNamespace("DiceEval")) { library(DiceEval)
## model: StepLinear
model <- modelFit(design.fact, y, type = "StepLinear")
filledcontourview(model, levels=30)
filledcontourview(branin, levels=30, col='red', add=TRUE)
}
}

}
\seealso{
\code{\link{sectionview.function}} for a section plot, and \code{\link{sectionview3d.function}} for a 2D section plot.

\code{\link{sectionview.km}} for a section plot, and \code{\link{sectionview3d.km}} for a 2D section plot.

\code{\link{sectionview.Kriging}} for a section plot, and \code{\link{sectionview3d.Kriging}} for a 2D section plot.

\code{\link{sectionview.NuggetKriging}} for a section plot, and \code{\link{sectionview3d.NuggetKriging}} for a 2D section plot.

\code{\link{sectionview.NoiseKriging}} for a section plot, and \code{\link{sectionview3d.NoiseKriging}} for a 2D section plot.

\code{\link{sectionview.glm}} for a section plot, and \code{\link{sectionview3d.glm}} for a 2D section plot.

\code{\link{sectionview.glm}} for a section plot, and \code{\link{sectionview3d.glm}} for a 2D section plot.
}
\author{
Yann Richet, IRSN
}
