% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree_days.R
\name{degree_days}
\alias{degree_days}
\title{Compute degree-days from daily minimum and maximum temperatures}
\usage{
degree_days(
  Tmin,
  Tmax,
  Tbase,
  Tupper = NULL,
  method = c("average", "average_cut", "triangle", "triangle_upper", "sine",
    "sine_upper")
)
}
\arguments{
\item{Tmin}{Daily minimum temperature (°C).}

\item{Tmax}{Daily maximum temperature (°C).}

\item{Tbase}{Base (lower developmental threshold) temperature (°C).}

\item{Tupper}{Optional upper temperature threshold (°C). Required for
\code{"triangle_upper"} and \code{"sine_upper"} methods.}

\item{method}{Degree-day method. One of \code{"average"}, \code{"average_cut"},
\code{"triangle"}, \code{"triangle_upper"}, \code{"sine"}, \code{"sine_upper"}.}
}
\value{
A numeric value (degree-days) rounded to 3 decimals.
}
\description{
Calculates daily degree-days (thermal units) from Tmin and Tmax using several
common methods (average, triangular, sine). Optionally, an upper threshold
(Tupper) can be applied in methods supporting it.
}
