% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCheck.R
\name{.runCheck}
\alias{.runCheck}
\title{Internal function to run and process each data quality check.}
\usage{
.runCheck(
  checkDescription,
  tableChecks,
  fieldChecks,
  conceptChecks,
  connectionDetails,
  connection,
  cdmDatabaseSchema,
  vocabDatabaseSchema,
  resultsDatabaseSchema,
  writeTableName,
  cohortDatabaseSchema,
  cohortTableName,
  cohortDefinitionId,
  outputFolder,
  sqlOnlyUnionCount,
  sqlOnlyIncrementalInsert,
  sqlOnly
)
}
\arguments{
\item{checkDescription}{The description of the data quality check}

\item{tableChecks}{A dataframe containing the table checks}

\item{fieldChecks}{A dataframe containing the field checks}

\item{conceptChecks}{A dataframe containing the concept checks}

\item{connectionDetails}{A connectionDetails object for connecting to the CDM database}

\item{connection}{A connection for connecting to the CDM database using the DatabaseConnector::connect(connectionDetails) function.}

\item{cdmDatabaseSchema}{The fully qualified database name of the CDM schema}

\item{vocabDatabaseSchema}{The fully qualified database name of the vocabulary schema (default is to set it as the cdmDatabaseSchema)}

\item{resultsDatabaseSchema}{The fully qualified database name of the results schema}

\item{writeTableName}{The table tor write DQD results to. Used when sqlOnly or writeToTable is True.}

\item{cohortDatabaseSchema}{The schema where the cohort table is located.}

\item{cohortTableName}{The name of the cohort table.}

\item{cohortDefinitionId}{The cohort definition id for the cohort you wish to run the DQD on. The package assumes a standard OHDSI cohort table called 'Cohort'}

\item{outputFolder}{The folder to output logs and SQL files to}

\item{sqlOnlyUnionCount}{(OPTIONAL) How many SQL commands to union before inserting them into output table (speeds processing when queries done in parallel). Default is 1.}

\item{sqlOnlyIncrementalInsert}{(OPTIONAL) Boolean to determine whether insert check results and associated metadata into output table.  Default is FALSE (for backwards compatability to <= v2.2.0)}

\item{sqlOnly}{Should the SQLs be executed (FALSE) or just returned (TRUE)?}
}
\value{
A dataframe containing the check results or SQL queries (NULL if sqlOnlyIncrementalInsert is TRUE)
}
\description{
Internal function to run and process each data quality check.
}
\keyword{internal}
