% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/besmi_batch.R
\name{besmi_batch_impute}
\alias{besmi_batch_impute}
\title{Run BESMI imputation for a list of dataset paths}
\usage{
besmi_batch_impute(
  dataset_paths,
  the_method = "lasso.norm",
  max_iter = 5,
  imputation_convergence_threshold = 1e-06,
  propagation_convergence_threshold = 1e-06,
  distance_metric = "mae",
  output_dir = file.path(tempdir(), "DataFusionGDM_imputation"),
  k_filter = NULL,
  full_dataset_path = NULL
)
}
\arguments{
\item{dataset_paths}{Character vector of RDS paths to masked matrices}

\item{the_method}{Imputation method (e.g., 'lasso.norm' or 'KNN')}

\item{max_iter}{Maximum iterations for iterative methods}

\item{imputation_convergence_threshold}{Convergence threshold for imputation metric}

\item{propagation_convergence_threshold}{Convergence threshold for propagation metric}

\item{distance_metric}{Distance metric for evaluation ('mae','ssd','rmse','correlation')}

\item{output_dir}{Output directory for imputed matrices (defaults to a temporary location)}

\item{k_filter}{Optional numeric filter for k value}

\item{full_dataset_path}{Optional path to a full matrix RDS used as ground truth}
}
\value{
Data frame of metrics for all datasets
}
\description{
Run BESMI imputation for a list of dataset paths
}
