% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Two_stage_sample_size.R
\name{Two_stage_sample_size}
\alias{Two_stage_sample_size}
\title{Calculate Sample Sizes for a Two-Stage Trial Design.}
\usage{
Two_stage_sample_size(
  median.1,
  median.2,
  gprior.E_1 = NULL,
  gprior.E_2 = NULL,
  L,
  U,
  S_likely = (L + U)/2,
  trunc.para = c(1, 1),
  err1,
  err2,
  FUP,
  rate,
  weight = 0.5,
  method = "optimal",
  earlystop_prob = NULL,
  seed = NULL
)
}
\arguments{
\item{median.1}{Numeric. The overall median survival time for SOC.}

\item{median.2}{Numeric. The overall median survival time for the experimental arm.}

\item{gprior.E_1}{Optional. A numeric vector of length two, representing the shape and scale
parameters of the inverse-gamma prior for \eqn{\mu_0}, the mean survival time before the separation time.
If \code{NULL}, the default is \code{c(4, 3 / (log(2) * median.1))}.}

\item{gprior.E_2}{Optional. A numeric vector of length two, representing the inverse-gamma prior
for \eqn{\mu_1}, the mean survival time after the separation time.
If \code{NULL}, the default is \code{c(4, 6 / (log(2) * median.1))}.}

\item{L}{Numeric. The lower bound of the separation time window.}

\item{U}{Numeric. The upper bound of the separation time window.}

\item{S_likely}{Numeric. The most likely separation time. Defaults to the midpoint of \code{L} and \code{U}.}

\item{trunc.para}{Numeric vector of length two. Specifies the shape and scale parameters of
the truncated gamma prior for the separation time.}

\item{err1}{Numeric. The pre-specified type I error rate (e.g., \code{0.1}).}

\item{err2}{Numeric. The pre-specified type II error rate (i.e., \eqn{\beta}, e.g., \code{0.2}).}

\item{FUP}{Numeric. The duration of follow-up per patient (in months or years). Default is 6.}

\item{rate}{Numeric. The recruitment rate (e.g., patients per month or year).}

\item{weight}{Numeric. Weight given to the expected sample size under \eqn{H_0}. Default is \code{0.5}.}

\item{method}{Character. Specifies which method to use:
\code{"optimal"} (default) or \code{"suboptimal"}. Determines how the sample size is calculated.}

\item{earlystop_prob}{Optional. Numeric. If specified, ensures that the probability of early
stopping under \eqn{H_0} is at least this value, while also maintaining the power at or above \eqn{1 - \beta}
when the separation time is no more than \code{U}.}

\item{seed}{Optional integer. If provided, sets the seed for reproducibility.}
}
\value{
A numeric vector of length 2. The first element is the required sample size for interim analysis, and the second element is the total sample size for final analysis in a two-stage design.
}
\description{
Computes the required sample sizes for the interim and final analyses in a two-stage trial design, based on pre-specified operating characteristics such as desired power, type I error rate assumptions.
}
\examples{
# Define design parameters
median.1 <- 4       # Median survival for standard-of-care
median.2 <- 6       # Median survival for experimental arm
L <- 2              # Lower bound of separation time
U <- 2.5            # Upper bound of separation time
S_likely <- 2.28    # Most likely separation time
rate <- 6           # Accrual rate (patients/month)
FUP <- 6            # Follow-up duration (months)
err1 <- 0.1         # Type I error
err2 <- 0.15        # Type II error

\donttest{
  Two_stage_sample_size(
    median.1 = median.1,
    median.2 = median.2,
    L = L,
    U = U,
    S_likely = S_likely,
    err1 = err1,
    err2 = err2,
    FUP = FUP,
    rate = rate,
    weight = 0.5,
    method = "optimal"
  )
}
}
