% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSLiteConnection.R
\name{dsConnect,DSLiteDriver-method}
\alias{dsConnect,DSLiteDriver-method}
\title{Connect to a DSLite server}
\usage{
\S4method{dsConnect}{DSLiteDriver}(drv, name, url, restore = NULL, profile = NULL, ...)
}
\arguments{
\item{drv}{\code{\linkS4class{DSLiteDriver}} class object.}

\item{name}{Name of the connection, which must be unique among all the DataSHIELD connections.}

\item{url}{A R symbol that refers to a \link{DSLiteServer} object that holds the datasets of interest. The
option "datashield.env" can be used to specify where to search for this symbol value. If not specified,
the environment is the global one.}

\item{restore}{Workspace name to be restored in the newly created DataSHIELD R session.}

\item{profile}{Name of the profile that will be given to the DSLiteServer configuration. Make different DSLiteServers to support different configurations.}

\item{...}{Unused, needed for compatibility with generic.}
}
\value{
A \code{\linkS4class{DSLiteConnection}} object.
}
\description{
Connect to a DSLite server, with provided datasets symbol names.
}
