% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRsurvfit.R
\name{summary.DRsurvfit}
\alias{summary.DRsurvfit}
\title{Summary method for DRsurvfit objects (multi-state SPCE / RMT-IF/RMST)}
\usage{
\method{summary}{DRsurvfit}(
  object,
  level = c("cluster", "individual"),
  tau = NULL,
  states = NULL,
  digits = 4,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{object}{A \code{DRsurvfit} object.}

\item{level}{Character: \code{"cluster"} or \code{"individual"} level summary.}

\item{tau}{Optional numeric vector of times at which to summarize both
\code{SPCE} and \code{RMTIF}/\code{RMST}. If \code{NULL}, the 25\%, 50\%,
and 75\% quantiles of the event-time grid are used.}

\item{states}{Optional integer vector of states to summarize for
\code{estimand = "SPCE"}. Defaults to all states \code{1:object$max_state}.}

\item{digits}{Number of digits to print for estimates and confidence limits.}

\item{alpha}{Nominal type I error for the intervals; coverage is
\code{1 - alpha}. Default is \code{0.05}, giving 95\% confidence intervals.}

\item{...}{Additional arguments passed to or from methods. Currently
unused.}
}
\value{
The input object \code{object}, invisibly.
}
\description{
Produces tabular summaries for multi-state doubly-robust estimators:
\itemize{
  \item For \code{estimand = "SPCE"}: stage-specific survival probabilities
        \eqn{S_s(t)} at selected times \eqn{\tau}, with optional jackknife
        t-based confidence intervals.
  \item For \code{estimand = "RMTIF"} or \code{"RMST"}: curves
        \eqn{R_1(\tau)}, \eqn{R_0(\tau)}, and \eqn{R_1(\tau) - R_0(\tau)}
        at the same set of \eqn{\tau}, again with optional jackknife
        t-based intervals.
}

The same argument \code{tau} is used for both estimands. If \code{tau} is
\code{NULL}, the function uses the 25\%, 50\%, and 75\% quantiles of the
event-time grid (excluding time 0 if present).
}
