% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMD.R
\name{GMD}
\alias{GMD}
\title{Generate Missing Data function}
\usage{
GMD(data, ratio)
}
\arguments{
\item{data}{A data frame containing the linear regression model dataset}

\item{ratio}{The missing ratio (e.g., 0.5 means 1/2 of data will be made missing)}
}
\value{
\item{data0}{A modified version of `data` with missing values inserted.}
}
\description{
This function generates missing data in a specified column of a 
data frame according to a given missing ratio.
}
\examples{
set.seed(123) # for reproducibility
data <- data.frame(x = 1:10, y = rnorm(10))
modified_data <- GMD(data, ratio = 0.5)
summary(modified_data)
}
