% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DERLS_InfoFilter.R
\name{DERLS_InfoFilter}
\alias{DERLS_InfoFilter}
\title{Distributed Exponentially Weighted Recursive Least Squares (DERLS) using Information Filter}
\description{
  Impute missing values in the response variable Y using a distributed Exponentially Weighted Recursive Least Squares (DERLS) method that employs an Information Filter.  
  Multiple independent runs are performed to stabilize coefficient estimates, and missing values are imputed recursively and refined over multiple iterations.
}
\usage{
DERLS_InfoFilter(data, rho, lambda, R, nb)
}
\arguments{
  \item{data}{
    A data frame whose first column is the response variable Y (which may contain NAs), and the remaining columns are predictor variables X.
  }
  \item{rho}{
    Regularization parameter.
  }
  \item{lambda}{
    Forgetting factor.
  }
  \item{R}{
    Number of independent runs to stabilize estimates.
  }
  \item{nb}{
    Number of iterations per run.
  }
}
\value{
  A list with two components:
  \item{Yhat}{
    A numeric vector of length n equal to the number of rows in data.  
    Missing values in the original Y have been imputed.
  }
  \item{betahat}{
    Numeric vector of final averaged regression coefficient estimates (length p, where p is the number of predictors).
  }
}

\examples{
set.seed(123)
n <- 60
data <- data.frame(
  Y = c(rnorm(n - 10), rep(NA, 10)),
  X1 = rnorm(n),
  X2 = rnorm(n)
)
result <- DERLS_InfoFilter(data, rho = 0.01, lambda = 0.95, R = 3, nb = 50)
head(result$Yhat)  # inspect imputed Y
result$betahat     # inspect estimated coefficients
}

