% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DERLS.R
\name{DERLS}
\alias{DERLS}
\title{Distributed Exponentially Weighted Recursive Least Squares (DERLS)}
\description{
  Impute missing values in the response variable Y using distributed ERLS method.
  Multiple independent runs are performed to stabilize coefficient estimates.
  Missing values are imputed recursively and refined over multiple iterations.
}
\usage{
DERLS(data, rho, lambda, R, nb)
}
\arguments{
  \item{data}{
    A data frame where:
    \describe{
      \item{First column:}{Response Y (with possible NAs)}
      \item{Remaining columns:}{Predictors X}
    }
  }
  \item{rho}{
    Regularization parameter.
  }
  \item{lambda}{
    Forgetting factor.
  }
  \item{R}{
    Number of independent runs to stabilize estimates.
  }
  \item{nb}{
    Number of iterations per run.
  }
}
\details{
  This function implements the Distributed Exponentially Weighted Recursive Least Squares (DERLS)
  method for imputing missing values in the response variable  Y. The key steps include:
  \enumerate{
    \item Initial imputation of missing values.
    \item Recursive updates of the regression coefficients using the ERLS algorithm.
    \item Multiple independent runs to stabilize the coefficient estimates.
    \item Final prediction of missing values using the averaged coefficients.
  }
  The ERLS algorithm is particularly useful for online learning and adaptive filtering.
}
\value{
  A list containing:
  \describe{
    \item{Yhat}{
      Imputed response vector.
    }
    \item{betahat}{
      Estimated coefficient vector.
    }
  }
}
\examples{
set.seed(123)
n <- 60
data <- data.frame(
  Y = c(rnorm(n - 10), rep(NA, 10)),  # 50 observed + 10 missing
  X1 = rnorm(n),
  X2 = rnorm(n)
)
result <- DERLS(data, rho = 0.01, lambda = 0.95, R = 3, nb = 50)
head(result$Yhat)  # inspect imputed Y
result$betahat      # inspect estimated coefficients
}
