% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback.R
\name{feedback_get_formatted_string}
\alias{feedback_get_formatted_string}
\title{Format the feedback string}
\usage{
feedback_get_formatted_string(print_this, type, findme, prefix, suffix)
}
\arguments{
\item{print_this}{(Optional, String, default: "")}

\item{type}{(Optional, String, default: "Info")
E.g. "Warning", "Error". Default: "Info"}

\item{findme}{(Optional, String, default: "")
Recommended with length 10.
String to find the message in the code.
E.g. 10-digit random hex from
\url{https://onlinetools.com/random/generate-random-hexadecimal-numbers}}

\item{prefix}{Prefix (Optional, String, default: "")
This is useful if print_this is an array/list.
Each entry will then be new row with this prefix.}

\item{suffix}{Suffix (Optional, String, default: "")
Same like prefix but at the end of each line.}
}
\value{
Returns a properly an consistent formatted string containing
  the parameters handed over to this function.
}
\description{
Helper function for the feedback function to combine the input
  parameters in proper manner to be a pretty and informative string which
  than can be added to the logfile and/or be displayed in the console.
  CAUTION: 'print_this' must be of length 1! For arrays loop through them
  by hand and call this function several times!
  Internal use. Use the robust 'feedback' function instead.
}
