% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{single_lm2}
\alias{single_lm2}
\title{Linear Regression Analysis for Specified Location}
\usage{
single_lm2(
  data,
  formula,
  location_var,
  response_distribution = "normal",
  family = NULL,
  location_index
)
}
\arguments{
\item{data}{The dataset to be analyzed.}

\item{formula}{The formula for the regression model.}

\item{location_var}{The variable indicating different locations (e.g., `REGCODE`).}

\item{response_distribution}{The distribution of the response variable ("normal" for normal distribution, "other" for other distributions).}

\item{family}{The family to be used for GLM if response_distribution is "other" (e.g., `binomial` for logistic regression).}

\item{location_index}{The specific location index or number for which the model should be run.}
}
\value{
A dataframe containing the results for the specified location.
}
\description{
This function runs a linear regression model for a specified location within a dataset.
}
\examples{
set.seed(123)
if (requireNamespace("dplyr", quietly = TRUE)) {
  library(dplyr)
# Create dummy data
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE)     # Represents district codes
) \%>\% arrange(district_code)

# Define a simple regression formula
formula <- years_education ~ gender_female + household_wealth + household_wealth:gender_female

# Run the regression for a specific location (e.g., district 1)
result_single_lm <- single_lm2(dummy_data, formula, "district_code",
 response_distribution = "normal", location_index = 1)

# View the result
print(result_single_lm)
}
}
