% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Replmre2}
\alias{Replmre2}
\title{Mixed-Effects Regression Analysis for All Locations}
\usage{
Replmre2(data, formula, location_var, random_effect_var)
}
\arguments{
\item{data}{The dataset to be analyzed.}

\item{formula}{The formula for the regression model.}

\item{location_var}{The variable indicating different locations (e.g., `REGCODE`).}

\item{random_effect_var}{The variable to be used as a random effect (e.g., `hhid`).}
}
\value{
A dataframe containing the results
}
\description{
This function runs a mixed-effects regression model for all locations within a dataset.
}
\examples{
set.seed(123)
library(dplyr)
# Create dummy data
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE)     # Represents district codes
) \%>\% arrange(district_code)

# Create HHid (Household ID), grouping every 3-4 records, and convert to character
dummy_data$HHid <- as.character(rep(1:20, each = 5, length.out = nrow(dummy_data)))

# Define a simple regression formula
formula <- years_education ~ gender_female + household_wealth:gender_female
location_var <- "district_code"
random_effect_var <- "HHid"

# Run mixed-effects regression for all districts
results <- DHSr::Replmre2(dummy_data, formula, location_var, random_effect_var)
print(head(results))
}
