% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-meta-bind-runner.R,
%   R/spec-meta-bind-formals.R, R/spec-meta-bind-expr.R
\docType{data}
\name{spec_meta_bind}
\alias{spec_meta_bind}
\title{spec_meta_bind}
\value{
\code{dbBind()} returns the result set,
invisibly,
for queries issued by \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}} or \code{\link[DBI:dbSendQueryArrow]{DBI::dbSendQueryArrow()}} and
also for data manipulation statements issued by
\code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}.
}
\description{
spec_meta_bind

spec_meta_bind

spec_meta_bind
}
\section{Specification}{

\pkg{DBI} clients execute parametrized statements as follows:
\enumerate{
\item Call \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}, \code{\link[DBI:dbSendQueryArrow]{DBI::dbSendQueryArrow()}} or \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}
with a query or statement that contains placeholders,
store the returned \link[DBI:DBIResult-class]{DBI::DBIResult} object in a variable.
Mixing placeholders (in particular, named and unnamed ones) is not
recommended.
It is good practice to register a call to \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}} via
\code{\link[=on.exit]{on.exit()}} right after calling \code{dbSendQuery()} or \code{dbSendStatement()}
(see the last enumeration item).
Until \code{\link[DBI:dbBind]{DBI::dbBind()}} or \code{\link[DBI:dbBind]{DBI::dbBindArrow()}} have been called,
the returned result set object has the following behavior:
\itemize{
\item \code{\link[DBI:dbFetch]{DBI::dbFetch()}} raises an error (for \code{dbSendQuery()} and \code{dbSendQueryArrow()})
\item \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}} returns zero (for \code{dbSendQuery()} and \code{dbSendQueryArrow()})
\item \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}} returns an integer \code{NA} (for \code{dbSendStatement()})
\item \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} returns \code{TRUE}
\item \code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}} returns \code{FALSE}
}
\item Call \code{\link[DBI:dbBind]{DBI::dbBind()}} or \code{\link[DBI:dbBind]{DBI::dbBindArrow()}}:
\itemize{
\item For \code{\link[DBI:dbBind]{DBI::dbBind()}}, the \code{params} argument must be a list where all elements
have the same lengths and contain values supported by the backend.
A \link{data.frame} is internally stored as such a list.
\item For \code{\link[DBI:dbBind]{DBI::dbBindArrow()}}, the \code{params} argument must be a
nanoarrow array stream, with one column per query parameter.
}
\item Retrieve the data or the number of affected rows from the \code{DBIResult} object.
\itemize{
\item For queries issued by \code{dbSendQuery()} or \code{dbSendQueryArrow()}, call \code{\link[DBI:dbFetch]{DBI::dbFetch()}}.
\item For statements issued by \code{dbSendStatements()},
call \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}.
(Execution begins immediately after the \code{\link[DBI:dbBind]{DBI::dbBind()}} call,
the statement is processed entirely before the function returns.)
}
\item Repeat 2. and 3. as necessary.
\item Close the result set via \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}.
}


The elements of the \code{params} argument do not need to be scalars,
vectors of arbitrary length
(including length 0)
are supported.
For queries, calling \code{dbFetch()} binding such parameters returns
concatenated results, equivalent to binding and fetching for each set
of values and connecting via \code{\link[=rbind]{rbind()}}.
For data manipulation statements, \code{dbGetRowsAffected()} returns the
total number of rows affected if binding non-scalar parameters.
\code{dbBind()} also accepts repeated calls on the same result set
for both queries
and data manipulation statements,
even if no results are fetched between calls to \code{dbBind()},
for both queries
and data manipulation statements.

If the placeholders in the query are named,
their order in the \code{params} argument is not important.

At least the following data types are accepted on input (including \link{NA}):
\itemize{
\item \link{integer}
\item \link{numeric}
\item \link{logical} for Boolean values
\item \link{character}
(also with special characters such as spaces, newlines, quotes, and backslashes)
\item \link{factor} (bound as character,
with warning)
\item \link[lubridate:date_utils]{lubridate::Date}
(also when stored internally as integer)
\item \link[lubridate:posix_utils]{lubridate::POSIXct} timestamps
\item \link{POSIXlt} timestamps
\item \link{difftime} values
(also with units other than seconds
and with the value stored as integer)
\item lists of \link{raw} for blobs (with \code{NULL} entries for SQL NULL values)
\item objects of type \link[blob:blob]{blob::blob}
}
}

\section{Failure modes}{

Calling \code{dbBind()} for a query without parameters
raises an error.


Binding too many
or not enough values,
or parameters with wrong names
or unequal length,
also raises an error.
If the placeholders in the query are named,
all parameter values must have names
(which must not be empty
or \code{NA}),
and vice versa,
otherwise an error is raised.
The behavior for mixing placeholders of different types
(in particular mixing positional and named placeholders)
is not specified.

Calling \code{dbBind()} on a result set already cleared by \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}
also raises an error.
}

\seealso{
Other meta specifications: 
\code{\link{spec_get_info}},
\code{\link{spec_meta_column_info}},
\code{\link{spec_meta_get_row_count}},
\code{\link{spec_meta_get_rows_affected}},
\code{\link{spec_meta_get_statement}},
\code{\link{spec_meta_has_completed}},
\code{\link{spec_meta_is_valid}}

Other meta specifications: 
\code{\link{spec_get_info}},
\code{\link{spec_meta_column_info}},
\code{\link{spec_meta_get_row_count}},
\code{\link{spec_meta_get_rows_affected}},
\code{\link{spec_meta_get_statement}},
\code{\link{spec_meta_has_completed}},
\code{\link{spec_meta_is_valid}}

Other meta specifications: 
\code{\link{spec_get_info}},
\code{\link{spec_meta_column_info}},
\code{\link{spec_meta_get_row_count}},
\code{\link{spec_meta_get_rows_affected}},
\code{\link{spec_meta_get_statement}},
\code{\link{spec_meta_has_completed}},
\code{\link{spec_meta_is_valid}}
}
\concept{meta specifications}
