% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{remove_stem}
\alias{remove_stem}
\title{Remove tree bole from `LAS`}
\usage{
remove_stem(las)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing an individually
segmented tree}
}
\value{
LAS object with stem removed
}
\description{
This function identifies and removes tree boles using the
`TreeLS` package available at \url{https://github.com/tiagodc/TreeLS}
}
\examples{
library(lidR)
library(CrownScorchTLS)

#'  #download external data from github repo
url <- paste0(
  "https://raw.githubusercontent.com/jbcannon/CrownScorchTLS-data/main/data/manual-clip-trees/",
  "M-04-15549_post.laz")
 las_file = tempfile(fileext = paste0(".", tools::file_ext(url)))
 download.file(url, las_file, mode = "wb", quiet = TRUE)
 las <- readLAS(las_file)

 # or load your own data
 #las <- readLAS('C:/path/to/your/file.laz')

#plot(las)
crown_only = remove_stem(las)
#plot(crown_only)
}
