Test.Gumbel<-function(x.obs,y.obs,dx,dy,lower=0.01,upper=50,U.plot=TRUE){
  res1=U1.Gumbel(x.obs,y.obs,dx,dy,lower,upper,U.plot)
  res2=U2.Gumbel(x.obs,y.obs,dx,dy,lower,upper,U.plot)
  theta1=res1["theta"]
  theta2=res2["theta"]
  tau1=res1["tau"]
  tau2=res2["tau"]

  stat=log(theta1)-log(theta2)

  Stat<-function(x.obs,y.obs,dx,dy){
    theta1=U1.Gumbel(x.obs,y.obs,dx,dy,lower,upper,U.plot=FALSE)["theta"]
    theta2=U2.Gumbel(x.obs,y.obs,dx,dy,lower,upper,U.plot=FALSE)["theta"]
    log(theta1)-log(theta2)
  }
  n=length(x.obs)
  T.del=numeric(n)
  for(i in 1:n){
    T.del[i]=Stat(x.obs[-i],y.obs[-i],dx[-i],dy[-i])
  }
  V=(n-1)^2/n*var(T.del)
  Z=stat/sqrt(V)
  P=1-pchisq(Z^2,df=1)

  Res=c(theta1=unname(theta1),tau1=unname(tau1),
        theta2=unname(theta2),tau2=unname(tau2),
        Z=unname(Z),P=unname(P))
  return(Res)
}
