% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrmse.R
\name{rmse}
\alias{rmse}
\alias{nrmse}
\title{(Normalized) root mean square error}
\usage{
rmse(a, b)

nrmse(a, b, normer = "sd")
}
\arguments{
\item{a, b}{numeric vectors of same length to be compared}

\item{normer}{a character string defining the type of
normalization to be applied. Can be one of
\describe{
\item{mean}{the arithmetic mean of a}
\item{sd}{the standard deviation of a (default).}
\item{range}{the difference between the range of a}
\item{IQR}{the difference between the interquantile range of a}
}}
}
\value{
The (normalised) rmse of the provided vector.
}
\description{
(Normalized) root mean square error

Calculate the (normalized) root-mean-square-error of
two vectors.
}
\examples{

set.seed(42)
a <- c(1, 2, 3, 4)
b <- a * rnorm(4, 1, 0.1)
rmse(a, b)
nrmse(a, b, normer = "sd")
nrmse(a, b, normer = "mean")


}
