% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_models.R
\name{combine_models}
\alias{combine_models}
\alias{combine_models.cfp_altres}
\alias{combine_models.list}
\alias{combine_models_by_reference}
\title{Combine models}
\usage{
combine_models(x)

\method{combine_models}{cfp_altres}(x)

\method{combine_models}{list}(x)

combine_models_by_reference(x_ref, x)
}
\arguments{
\item{x}{A list of models, must inherit from \code{\link[=cfp_dat]{cfp_dat()}}}

\item{x_ref}{Reference element of x that controls the return class and
attributes.}
}
\value{
An object of the same type as  the first object in \code{x}.
}
\description{
Combinea list of multiple models or \code{\link[=cfp_dat]{cfp_dat()}} objects into a single object.
}
\examples{
mod1 <- filter(base_dat, site == "site_a")
mod2 <- filter(base_dat, site == "site_b")
combine_models(list(mod1, mod2))

# use a reference model for coercion
combine_models_by_reference(mod1, list(mod1, mod2))
}
