% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC_basic.R
\name{PPC_basic}
\alias{PPC_basic}
\title{Perform Basic Projected PCA (PPC) Estimation}
\usage{
PPC_basic(data, m)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p).}

\item{m}{Integer. The number of principal components (factors) to extract.}
}
\value{
A list containing:
\item{Apro}{Estimated projected factor loadings matrix (p x m).}
\item{Dpro}{Estimated projected uniquenesses vector (p).}
\item{Sigmahatpro}{The covariance matrix of the projected data.}
}
\description{
This function performs Projected Principal Component Analysis (PPC) to estimate factor loadings
and specific variances. It projects the data onto a specific subspace before performing eigen
decomposition. Unlike \code{\link{PPC_CoFM}}, this function does not calculate error metrics
against true parameters.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# 1. Generate toy data using CoFM
sim <- CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2.0)
obs_data <- sim$data

# 2. Apply PPC method (extract 2 factors)
fit <- PPC_basic(data = obs_data, m = 2)

# 3. Inspect estimates
head(fit$Apro)
fit$Dpro
}
