% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FanPC_basic.R
\name{FanPC_basic}
\alias{FanPC_basic}
\title{Perform Basic FanPC Factor Analysis}
\usage{
FanPC_basic(data, m)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p).}

\item{m}{Integer. The number of principal components (factors) to extract.}
}
\value{
A list containing:
\item{AF}{Estimated factor loadings matrix (p x m).}
\item{DF}{Estimated uniquenesses vector (p).}
\item{SigmahatF}{The correlation matrix of the input data.}
}
\description{
This function performs factor analysis using a principal-component (FanPC) approach.
It estimates the factor loading matrix and uniquenesses from the correlation matrix
of the input data. Unlike \code{\link{FanPC_CoFM}}, this function does not calculate
error metrics against true parameters, making it suitable for simple estimation tasks.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# 1. Generate synthetic data using CoFM (toy example)
sim <- CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2.0)
obs_data <- sim$data

# 2. Apply FanPC method (extract 2 factors)
fit <- FanPC_basic(data = obs_data, m = 2)

# 3. Inspect estimates
head(fit$AF)  # Estimated loadings
fit$DF        # Estimated uniquenesses
}
