% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula_errors.R
\name{Copula_errors}
\alias{Copula_errors}
\title{Generate Copula-Distributed Error Terms}
\usage{
Copula_errors(
  n,
  type = "Clayton",
  dim = 2,
  param = NULL,
  extra_params = list()
)
}
\arguments{
\item{n}{Integer. The number of samples (rows) to generate.}

\item{type}{Character. The type of Copula to use. Options: "Clayton", "Gumbel",
"Frank", "t", "Mixed", "Galambos", "Normal".}

\item{dim}{Integer. The dimension of the copula (number of columns/variables).
Used for Archimedean/Elliptical copulas. For "Mixed" the default is 3.}

\item{param}{Numeric or Matrix. The main parameter for the copula (e.g., theta for
Archimedean, correlation vector/matrix for Normal). If NULL, default values are used.}

\item{extra_params}{List. Additional parameters for specific copulas (e.g., \code{df} for t-Copula,
\code{w} for Mixed).}
}
\value{
A numeric matrix of dimension (n x dim) containing the generated random samples.
}
\description{
Generate random samples (error terms) from various copula distributions,
including Archimedean (Clayton, Gumbel, Frank), Elliptical (t, Normal),
Mixed, and Extreme-Value (Galambos) copulas. Useful for simulation studies
involving non-normal error structures.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# Example 1: Clayton Copula (toy example)
U_clayton <- Copula_errors(n = 200, type = "Clayton", dim = 2, param = 2)
head(U_clayton)

# Example 2: t-Copula with degrees of freedom (toy example)
U_t <- Copula_errors(
  n = 200, type = "t", dim = 2, param = 0.7,
  extra_params = list(df = 4)
)
head(U_t)

# Example 3: Multivariate Normal Copula (dim = 3)
# normalCopula() expects the upper-triangular correlations as a vector:
# (rho_12, rho_13, rho_23) for dim=3
rho_vec <- c(0.5, 0.3, 0.4)
U_normal <- Copula_errors(n = 200, type = "Normal", dim = 3, param = rho_vec)
head(U_normal)
}
