\name{axialnntssimulation}
\alias{axialnntssimulation}
\title{
NNTS axial density simulation function
}
\description{
Simulation for the density function for the NNTS axial model
}
\usage{
axialnntssimulation(nsim=1, cpars = 1/pi, M = 0)
}
\arguments{
  \item{nsim}{Number of simulations}
  \item{cpars}{Parameters of the model. A vector of complex numbers of dimension M+1. The sum of the squared moduli of the c parameters must be equal to 1/pi}
  \item{M}{Number of components in the NNTS axial model}
}

\value{A list with two components:
\item{simulations}{The function generates a vector with nsim simulated random values from the NNTS axial density function}
\item{conteo}{Number of uniform random numbers used to obtain the nsim simulations by the acceptance-rejection simulation method}
}

\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez
}
\examples{
set.seed(1234567)
ccoef<-axialnntsrandominitial(M=4)
data<-axialnntssimulation(100,ccoef,M=4)$simulations
hist(data,breaks=seq(0,pi,pi/7),xlab="Orientations (radians)",freq=FALSE,
ylab="",main="",ylim=c(0,1))
axialnntsplot(ccoef,M=4,add=TRUE)
}


