\name{CircNNTSRSymmetric-package}
\Rdversion{0.1.0}
\alias{CircNNTSRSymmetric-package}
\alias{CircNNTSRSymmetric}
\docType{package}
\title{CircNNTSRSymmetric: An R Package for the statistical analysis of circular data using symmetric nonnegative trigonometric
sums (NNTS) models. Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME]
(available at https://arxiv.org/abs/2412.19501)
}
\description{
The statistical analysis of circular data using distributions based on symmetric Nonnegative Trigonometric Sums (NNTS). 
It includes functions to perform empirical analysis and estimate the parameters of density functions. Fernández-Durán, J.J. and Gregorio-Domínguez, M.M. (2025) <doi:10.48550/arXiv.2412.19501>.
}
\details{\tabular{ll}{
Package: \tab CircNNTSRSymmetric\cr
Type: \tab Package\cr
Version: \tab 0.1.0\cr
Date: \tab 2025-02-02\cr
License: \tab GLP (>=2)\cr
LazyLoad: \tab yes\cr
}

The NNTS (Non-Negative Trigonometric Sums) symmetric density around \eqn{\mu} is defined as:
\deqn{f(\theta; M, \underline{c}, \mu)= \sum_{k=0}^M\sum_{l=0}^M \rho_k\rho_l e^{i(k-l)(\theta - \mu)}}
with \eqn{\rho_k} real numbers for \eqn{k=0, \ldots, M} with \eqn{\sum_{k=0}^M \rho_k^2 = \frac{1}{2\pi}}.

Equivalently, the symmetric NNTS density is:
\deqn{f(\theta; M, \underline{c}, \mu)= \frac{1}{2\pi}\sum_{k=0}^M\sum_{l=0}^M ||c_k|| ||\bar{c}_l|| e^{i(k-l)(\theta - \mu)} =
\frac{1}{2\pi}\sum_{k=0}^M\sum_{l=0}^M c_{Sk} \bar{c}_{Sl} e^{i(k-l)\theta}}.
The parameters \eqn{c_{Sk}=||c_k||e^{-ik\mu}} are the parameters of the general (non-symmetric) NNTS model.

The symmetric NNTS model is derived from the general NNTS model (Fernández-Durán, 2004 and Fernández-Durán and Gregorio-Domínguez, 2016) with norms (moduli) of the \eqn{c} parameters equal in both models and arguments of the \eqn{c} parameters equal to \eqn{\phi_k=-k\mu} for \eqn{k=1,2, \ldots, M}.
}

\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez

Maintainer: Maria Mercedes Gregorio Dominguez <mercedes@itam.mx>

}
\references{
Fernández-Durán, J.J. (2004). Circular Distributions Based on Nonnegative Trigonometric Sums. \emph{Biometrics}, 60, pp. 499-503.

Fernández-Durán, J.J. and Gregorio-Domínguez, M.M. (2016). CircNNTSR: An R Package for the Statistical Analysis of Circular, Multivariate Circular, and Spherical Data Using Nonnegative Trigonometric Sums. \emph{Journal of Statistical Software}, 70(6), 1-19. doi:10.18637/jss.v070.i06

Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME] (available at https://arxiv.org/abs/2412.19501)}

\keyword{ package }
%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}

