test_that("xpose used for eta distribution  ", {
  workingDir <- system.file("extdata/eta_distrib",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )
  modelName <- "OneCpt1stOrderAbsorp_CountHazardImax"
  dmp.json <- paste0(modelName, "_dmp.json")
  dmp.txt <- jsonlite::fromJSON(readLines(file.path(workingDir, dmp.json)))

  residuals.csv <- paste0(modelName, "_residuals.csv")
  dmp.txt$residuals <- utils::read.csv(file.path(workingDir, residuals.csv))

  dataFile <- paste0(modelName, ".csv")

  logFile <- paste0(modelName, "_nlme7engine.log")

  xpdb <- xposeNlme(
    dir = workingDir,
    dmp.txt = dmp.txt,
    dataFile = dataFile,
    logFile = logFile
  )


  testthat::local_edition(3)
  testthat::expect_snapshot(tail(as.data.frame(xpdb$data$data[[1]])))
})
