% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyVPC.R
\name{vpcResultsUI}
\alias{vpcResultsUI}
\title{Shiny GUI to parameterize Visual Predictive Check (VPC)}
\usage{
vpcResultsUI(
  observed,
  simulated,
  ObsName = NULL,
  vpc.type = c("continuous", "categorical"),
  tagged = NULL,
  settings = NULL,
  ...
)
}
\arguments{
\item{observed}{Observed input data.}

\item{simulated}{Simulated input data.}

\item{ObsName}{Optional character value specifiying the name of the observed dependent variable (e.g., ObsName).}

\item{vpc.type}{Character value specifying type of VPC.}

\item{tagged}{A list of tagged VPC's or model diagnostics created from previous \code{Certara.VPC} or \code{Certara.ModelResults} session.}

\item{settings}{A list of plot customization settings used in previous \code{Certara.VPC} or \code{Certara.ModelResults} session.}

\item{...}{Arguments for initiation from Pirana.}
}
\value{
If \code{interactive()}, returns a list of tagged diagnostics from the Shiny application, otherwise returns \code{TRUE}.
}
\description{
Use \code{tidyvpc} package to parameterize VPC from Shiny GUI and customize plot
using \code{ggplot2}. Code generation functionality allows you to reproduce \code{tidyvpc}
object and \code{ggplot2} plot in your local R session via R script saved to your working
directory.
}
\examples{
if (interactive()) {
vpcResultsUI(tidyvpc::obs_data, tidyvpc::sim_data)
}

}
