% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_StParm.R
\name{modify_StParm}
\alias{modify_StParm}
\title{Modify structural parameter in PML models set}
\usage{
modify_StParm(
  PMLParametersSets,
  StParmName,
  Type = "LogNormal",
  State = "Present",
  ThetaStParm,
  OmegaStParm,
  Covariates,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{StParmName}{Character specifying the name of the structural parameter
to be modified.}

\item{Type}{Character specifying the type of the structural parameter. Options are
\itemize{
\item \code{LogNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV * wt^dVdwt * exp(nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{LogNormal1} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = (tvV + wt*dVdwt) * exp(nV + nVx0*( Occasion==0) + nVx1*( Occasion==1)))}
\itemize{
\item \code{LogNormal2} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = exp(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occason==1)))}
\itemize{
\item \code{LogitNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = ilogit(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{Normal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1))}}

\item{State}{character string that indicates the presence of the structural
parameter. Options are:
\itemize{
\item \code{None} The structural parameter does not exist in the specified \code{PMLStructures}.
\item \code{Present} The structural parameter exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the structural parameter  is searched.
}}

\item{ThetaStParm}{A Theta class instance inside the structural parameter. If
not given, the associated Theta will be automatically created with its name
set to "tv" + \code{StParmName}.}

\item{OmegaStParm}{An Omega class instance inside the structural parameter.
If not given, the associated Omega will be automatically created with its
name set to "n" + \code{StParmName}}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the structural parameter statement.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures to which the structural parameter will be added. For the naming
convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Modify structural parameter in PML models set
}
\details{
This function can only be used to modify the structural parameters
in the built-in models (i.e., created using either \code{create_ModelEmax()} or
\code{create_ModelPK()}) or in the custom models if they are added with
\code{add_StParm()}.
}
\examples{
PMLParametersSets <-
  get_PMLParametersSets(CompartmentsNumber = c(1, 2, 3))
# update structural parameter type
PMLParametersSetsVMod <-
 modify_StParm(PMLParametersSets,
            StParmName = "V",
            Type = "LogitNormal")

}
\seealso{
\code{\link[=Dosepoint]{Dosepoint()}} \code{\link[=list_StParms]{list_StParms()}}

Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{add_StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParmCustom}()},
\code{\link{remove_StParm}()}
}
\concept{StParms}
