% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ModelEmax.R
\name{create_ModelPD}
\alias{create_ModelPD}
\title{Get the list of objects describing the PML models by set of PD parameters}
\usage{
create_ModelPD(
  Type = "Emax",
  Baseline = FALSE,
  Fractional = FALSE,
  Inhibitory = FALSE,
  Sigmoid = FALSE,
  ByVector = FALSE,
  ...
)
}
\arguments{
\item{Type}{Pharmacodynamic model type. Currently, only Emax is supported.}

\item{Baseline}{Logical indicating whether the Emax model contains a baseline
response. If it is set to TRUE,  the new parameter, E0, for baseline
response is added to the model. Default is \code{FALSE}.}

\item{Fractional}{Logical indicating whether the Emax model with baseline
response is fractional. Applicable only for the Emax models with baseline
response, otherwise a warning is given and current parameter is ignored.
Default is \code{FALSE}.}

\item{Inhibitory}{Logical indicating whether the model is inhibitory. If it
is set to TRUE, the structural parameters 'EC50' and 'Emax' change to
'IC50' (concentration producing 50\% of maximal inhibition) and 'Imax'.
Default is \code{FALSE}.}

\item{Sigmoid}{Logical indicating whether the model is sigmoidal. If it is
set to TRUE, the Hill coefficient, 'Gam', is added to the model. Default is
\code{FALSE}.}

\item{ByVector}{Logical indicating whether each element in vectorized
argument should be treated as a separate PML structure (i.e. treated as
data.frame vectors), \code{TRUE}, or as parameters to obtain a pool (i.e.
expanded) of PML structures, \code{FALSE}. Default is \code{FALSE} (one value for a
function call).}

\item{...}{Additional named arguments, including Structural parameters
(StParm), Covariates, Dosepoints (for PK models), Thetas and Omegas. See
'Additional arguments' section.}
}
\value{
A list of PML models (\code{PMLModels} class instance) matching the
specified options.
}
\description{
This function provides the PML (Pharmacometric Modelling Language) PD
parameter sets based on the specified options. They are available as a list
of specific S3 classes.
}
\details{
The names of \code{PMLStructure} are constructed by the following parts:
\itemize{
\item Baseline if presented (abbreviated as 'E0'),
\item Fractional if presented (abbreviated as '1+'),
\item Inhibitory (abbreviated as 'Imax' if the model is inhibitory and 'Emax' otherwise),
\item Sigmoid  if presented (abbreviated as 'Gam').
}
}
\section{Additional arguments}{
Additional arguments (ellipsis) will be applied
sequentially. They can be used to add or modify Structural parameters
(StParm), Covariates, Observations, Dosepoints (for PK models); by the way it is advised to
use specific functions for it (see 'See Also' section for the references).
Also it is possible to modify Omegas and Thetas, but it is impossible to add
them (they are parts of other structures). If \code{PMLStructure} argument is not
specified, class instances will be modified or added in all PML structures.
If \code{PMLStructure} argument is specified, class instances in the specified PML
structure will be modified/added. Note that only one PML structure could be
added to the class instance. If multiple structures should be modified,
suggest to use specific functions.
}

\examples{
# Get PD model set with default options
PDParametersSets <- create_ModelPD(Type = "Emax")

# Create PD model set with all possible combinations
# will give a warning since When 'Baseline == FALSE',
# there could be no model with 'Fractional == TRUE'
PDParametersSets <-
  create_ModelPD(Type = "Emax",
                 Baseline = FALSE,
                 Inhibitory = c(FALSE, TRUE),
                 Sigmoid = c(FALSE, TRUE),
                 ByVector = FALSE)

}
\seealso{
Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{add_StParm}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParm}()},
\code{\link{modify_StParmCustom}()},
\code{\link{remove_StParm}()}

Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{ObservationCustom}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Observation}()},
\code{\link{remove_Observation}()}

Functions used for Omega specification: 
\code{\link{Omega}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Omega}()}

Functions used for Theta specification: 
\code{\link{InitialEstimate}()},
\code{\link{Theta}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Theta}()}

Functions used for Covariate specification: 
\code{\link{Covariate}()},
\code{\link{add_Covariate}()},
\code{\link{create_ModelPK}()},
\code{\link{remove_Covariate}()}
}
\concept{Covariates}
\concept{Observations}
\concept{Omegas}
\concept{StParms}
\concept{Thetas}
