% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObservationClass.R
\name{Observation}
\alias{Observation}
\title{Create an instance of Observation class.}
\usage{
Observation(
  ObservationName = "CObs",
  SigmasChosen = Sigmas(Proportional = 0.1),
  BQL = FALSE,
  BQLValue = NA,
  Frozen = FALSE,
  ResetObs = FALSE,
  Covariates = list(),
  PMLStructure = character()
)
}
\arguments{
\item{ObservationName}{A character string giving the name of the Observation.}

\item{SigmasChosen}{a \link{Sigmas} class instance or a list specifying the
chosen sigma values for different error models. 0s are treated as no
values. Inside Observation class it is transormed and kept as \link{Sigmas}
class. The list could contain the following error models:
\itemize{
\item Additive The additive error sigma value.
\item LogAdditive The log-additive error sigma value.
\item Proportional The proportional error sigma value.
\item AdditiveMultiplicative A numeric vector specifying the additive and multiplicative parts
for the additive-multiplicative error model. The vector should have names
\code{PropPart} and \code{AddPart}.
\item MixRatio A numeric vector specifying the proportional and additive parts for the mix-ratio
error model. The vector should have names \code{PropPart} and \code{AddPart}.
\item Power A numeric vector specifying the standard deviation and power parts for the power error model.
The vector should have names \code{StdevPart} and \code{PowerPart}.
}}

\item{BQL}{A logical value indicating whether the dataset contains BQL values
and they should be taken into account (M3 method).}

\item{BQLValue}{An optional numeric positive value of static LLOQ. Applicable
only when BQL argument is \code{TRUE}. Any observed value less than or equal to
that LLOQ value is treated as censored.}

\item{Frozen}{A logical value indicating if the standard deviation (Stdev) is
frozen.}

\item{ResetObs}{A logical value indicating if the Observation variable should
be reset to 0 after observation (\code{doafter={A0=0;}}). Applicable for
elimination compartment.}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the model, but not linked to any of structural parameters.
Used with "Emax" PD models ('C' covariate is added automatically when
creating a new model, but should be added manually when modifying the model).}

\item{PMLStructure}{Character specifying the name of PML structure in which
the observation should be added. For the naming convention of
PMLStructures, see Details section of \code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
A new Observation object
}
\description{
This function creates a new instance of Observation object and validates it.
}
\examples{
A0Obs <-
  Observation(ObservationName = "A0Obs",
              SigmasChosen = list(Additive = 2,
                                  Power = c(Stdev = 10, Power = 0.5)),
              Frozen = FALSE,
              ResetObs = TRUE,
              PMLStructure = "PK1FOC")

CObs <- Observation("CObs", Frozen = TRUE, PMLStructure = "2Cpt")

}
\seealso{
Functions used for Observation specification: 
\code{\link{ObservationCustom}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Observation}()},
\code{\link{remove_Observation}()}
}
\concept{Observations}
