% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_sample_data.R
\name{make_sample_data}
\alias{make_sample_data}
\title{Generate sample cardiovascular risk data}
\usage{
make_sample_data(n = 100)
}
\arguments{
\item{n}{Number of rows to generate (default: 100)}
}
\value{
A data frame with \code{n} rows and the following columns:
\describe{
  \item{id}{Sequential patient identifier (1 to n)}
  \item{age}{Patient age in years (30-79)}
  \item{sex}{Sex at birth ("female" or "male")}
  \item{race}{Patient race ("white", "aa", or "other")}
  \item{sbp}{Systolic blood pressure in mm Hg (90-200)}
  \item{bp_med}{Blood pressure medication status (TRUE/FALSE)}
  \item{totchol}{Total cholesterol in mg/dL (130-320)}
  \item{hdl}{HDL cholesterol in mg/dL (20-100)}
  \item{lipid_med}{Lipid medication status (TRUE/FALSE)}
  \item{diabetes}{Diabetes status (TRUE/FALSE)}
  \item{smoker}{Smoking status (TRUE/FALSE)}
  \item{egfr}{Estimated glomerular filtration rate in mL/min/1.73m2 (15-140)}
  \item{bmi}{Body mass index in kg/m2 (18.5-39.9)}
  \item{hba1c}{Hemoglobin A1c percentage (4.5-15.0 or NA)}
  \item{uacr}{Urine albumin-to-creatinine ratio in mg/g (0.1-25000 or NA)}
  \item{zip}{ZIP code (30 valid codes or NA)}
}
}
\description{
Creates a data frame with randomly generated patient data suitable for testing
cardiovascular risk calculations. The function generates realistic ranges for
all standard cardiovascular risk factors.
}
\examples{
library(CVrisk)
# Generate default 100 rows
sample_data <- make_sample_data()

# Generate 50 rows
sample_data_50 <- make_sample_data(n = 50)

# Use with compute_CVrisk
\dontrun{
data <- make_sample_data(n = 10)
result <- compute_CVrisk(
  data,
  scores = "ascvd_10y_accaha",
  age = "age",
  gender = "sex",
  race = "race",
  sbp = "sbp",
  totchol = "totchol",
  hdl = "hdl",
  bp_med = "bp_med",
  smoker = "smoker",
  diabetes = "diabetes"
)
}
}
