% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSeQTL.R
\name{CSeQTL_linearTest}
\alias{CSeQTL_linearTest}
\title{CSeQTL_linearTest}
\usage{
CSeQTL_linearTest(
  input,
  XX,
  RHO,
  SNP,
  YY = NULL,
  MARG = FALSE,
  impute_geno = FALSE,
  trim = FALSE,
  thres_TRIM = 10,
  show_plot = TRUE,
  main_plot = "",
  CTs = NULL
)
}
\arguments{
\item{input}{A data.frame containing columns \code{total}
(total read counts) and \code{log_lib_size} (log transformed
library size).}

\item{XX}{A numeric design matrix of baseline covariates 
including the intercept in the first column and centered 
continuous covariates.}

\item{RHO}{A numeric matrix of cell type proportions. Rows 
correspond to subjects and columns correspond to cell types.}

\item{SNP}{An integer vector of phased genotypes coded 0 (AA),
1 (AB), 2 (BA), 3 (BB), and 5 (NA).}

\item{YY}{Default is \code{NULL}. By default, the outcome
for OLS is the inverse rank quantile normalized TReC 
after library size correction. Otherwise, the user can input
their own transformed outcome as a numeric vector.}

\item{MARG}{Boolean value. Set to \code{TRUE} to fit the
marginal OLS model. Default is set to \code{FALSE} to fit
the cell type-specific interaction OLS model.}

\item{impute_geno}{Boolean value. Default is set to \code{FALSE}
to only analyze subjects with non-missing genotype.
If \code{TRUE}, missing genotypes are imputed with the 
mean of non-missing genotypes mimicing \code{MatrixEQTL}.}

\item{trim}{Boolean value set to \code{FALSE} by default to prevent
outcome trimming. If \code{TRUE}, the OLS model will be fitted
without covariates containing SNP genotype to calculate each 
subject's Cooks' distance.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{show_plot}{Boolean value set to \code{TRUE} to visualize
boxplot or interactions.}

\item{main_plot}{Character string for the visual's main title.}

\item{CTs}{Set to \code{NULL} by default. If \code{NULL} and 
\code{show_plot = TRUE}, all cell type interaction plots are shown.
Otherwise a subset of cell types can be displayed using an integer vector
of columns or character vector of column names of \code{RHO} can 
be provided.}
}
\value{
A R list containing \code{lm()} output for \code{lm_out}, 
a R dataframe for \code{out_df} containing regression estimates, 
standard errors, p-values. \code{res_trim} provides a summary of trimmed 
results over a grid of cut-off values and number of samples trimmed.
\code{cooksd} is a numeric vector of median shifted and MAD scaled 
Cook's distances per sample. \code{prop_trim}, a numeric value for 
number of samples with outcome values trimmed for the user-specified
\code{thres_TRIM} value.
}
\description{
Runs marginal and cell type-specific 
analysis using ordinary least squares.
}
