% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCRT.R
\name{plotCRT}
\alias{plotCRT}
\title{Graphical displays of the geography of a CRT}
\usage{
plotCRT(
  object,
  map = FALSE,
  distance = "nearestDiscord",
  fill = "arms",
  showLocations = FALSE,
  showClusterBoundaries = TRUE,
  showClusterLabels = FALSE,
  showBuffer = FALSE,
  cpalette = NULL,
  buffer_width = NULL,
  maskbuffer = 0.2,
  labelsize = 4,
  legend.position = NULL
)
}
\arguments{
\item{object}{object of class \code{'CRTanalysis'} produced by \code{CRTanalysis()}}

\item{map}{logical: indicator of whether a map is required}

\item{distance}{measure of distance or surround with options: \cr
\tabular{ll}{
\code{"nearestDiscord"} \tab distance to nearest discordant location (km)\cr
\code{"disc"} \tab disc\cr
\code{"hdep"} \tab Tukey's half space depth\cr
\code{"sdep"} \tab simplicial depth\cr
}}

\item{fill}{fill layer of map with options:
\tabular{ll}{
\code{'cluster'} \tab cluster assignment \cr
\code{'arms'}   \tab arm assignment \cr
\code{'nearestDiscord'} \tab distance to the nearest discordant location\cr
\code{'disc'} \tab disc measure of surround\cr
\code{'hdep'} \tab Tukey's half space depth\cr
\code{'sdep'} \tab simplicial depth\cr
\code{'prediction'}\tab model prediction of the outcome \cr
\code{'none'}\tab No fill \cr
}}

\item{showLocations}{logical: determining whether locations are shown}

\item{showClusterBoundaries}{logical: determining whether cluster boundaries are shown}

\item{showClusterLabels}{logical: determining whether the cluster numbers are shown}

\item{showBuffer}{logical: whether a buffer zone should be overlayed}

\item{cpalette}{colour palette (to use different colours for clusters this must be at
least as long as the number of clusters.}

\item{buffer_width}{width of buffer zone to be overlayed (km)}

\item{maskbuffer}{radius of buffer around inhabited areas (km)}

\item{labelsize}{size of cluster number labels}

\item{legend.position}{(using \code{ggplot2::themes} syntax)}
}
\value{
graphics object produced by the \code{ggplot2} package
}
\description{
\code{plotCRT} returns graphical displays of the geography of a CRT
or of the results of statistical analyses of a CRT
}
\details{
If \code{map = FALSE} and the input is a trial data frame or a \code{CRTsp} object,
containing a randomisation to arms, a stacked bar chart of the outcome
grouped by the specified \code{distance} is produced. If the specified \code{distance}
has not yet been calculated an error is returned.\cr\cr
If \code{map = FALSE} and the input is a \code{CRTanalysis} object a plot of the
estimated spillover function is generated. The fitted spillover function is plotted
as a continuous green/blue line against the measure of
the surround or of the distance to the nearest discordant location. Using the same axes, data summaries are plotted for
ten categories of distance from the boundary. Both the
average of the outcome and confidence intervals are plotted.If spillover limits have been estimated
then these limits are used to delimit a shaded rectangular overlay, providing they fall within the range of distances
in the data. If the spillover limits fall outside the range of the data then the range of distances in the data
define the boundaries of the shaded area.
\itemize{
\item For analyses with logit link function the outcome is plotted as a proportion. \cr
\item For analyses with log or cloglog link function the data are plotted on a scale of the Williams mean
(mean of exp(log(x + 1))) - 1) rescaled so that the median matches the fitted curve at the midpoint.\cr
}
If \code{map = TRUE} a thematic map corresponding to the value of \code{fill} is generated.
\itemize{
\item \code{fill = 'clusters'} or leads to thematic map showing the locations of the clusters
\item \code{fill = 'arms'} leads to a thematic map showing the geography of the randomization
\item \code{fill = 'distance'} leads to a raster plot of the distance to the nearest discordant location.
\item \code{fill = 'prediction'} leads to a raster plot of predictions from an \code{'INLA'} model.
}
If \code{showBuffer = TRUE} the map is overlaid with a grey transparent layer showing which
areas are within a defined distance of the boundary between the arms. Possibilities are:
\itemize{
\item If the trial has not been randomised or if \code{showBuffer = FALSE} no buffer is displayed
\item If \code{buffer_width} takes a positive value then buffers of this width are
displayed irrespective of any pre-specified or spillover limits.
\item If the input is a \code{'CRTanalysis'} and spillover limits have been estimated
then these limits are used to define the displayed buffer providing they fall within the range of distances
in the data.
\item If \code{buffer_width} is not specified and no spillover limits are available, then any
pre-specified buffer (e.g. one generated by \code{specify_buffer()}) is displayed.
}
A message is output indicating which of these possibilities applies.
}
\examples{
{example <- readdata('exampleCRT.txt')
#Plot of data by distance
plotCRT(example)
#Map of locations only
plotCRT(example, map = TRUE, fill = 'none', showLocations = TRUE,
           showClusterBoundaries=FALSE, maskbuffer=0.2)
#show cluster boundaries and number clusters
plotCRT(example, map = TRUE, fill ='none', showClusterBoundaries=TRUE,
           showClusterLabels=TRUE, maskbuffer=0.2, labelsize = 2)
#show clusters in colour
plotCRT(example, map = TRUE, fill = 'clusters', showClusterLabels = TRUE,
          labelsize=2, maskbuffer=0.2)
#show arms
plotCRT(example, map = TRUE,
fill = 'arms', maskbuffer=0.2, legend.position=c(0.8,0.8))
#spillover plot
analysis <- CRTanalysis(example)
 plotCRT(analysis, map = FALSE)
}
}
