#' plotSigMat
#'
#' This function is used to generate the signature by component matrix plot.
#' 
#' @param sigs Signature by component matrix
#' @param runName Name of the run used in plot titles, Default is ""
#' @param saveRes Whether or not to save the plots, Default is FALSE
#' @param saveDir Where to save the plots, must be provided if using saveDir
#' @return pheatmap figure of component weights by sample
#' @keywords plot signature matrix
#' @export
#' @examples
#' plotSigMat(sigsExp)
#' 
plotSigMat = function(sigs, runName="", saveRes = FALSE, saveDir = NULL) {

  # Generates the plot title using the given runName
  if (nchar(runName) > 0){
    plotTitle = paste0("Signature Component Weights (",runName,")")
  } else {
    plotTitle = "Signature Component Weights"
  }
  
  # Creates the plot using pheatmap
  if (saveRes){
    if (is.null(saveDir)){
	stop('No saveDir provided for saveRes. Please set saveDir.')
    }
    grDevices::tiff(paste0(saveDir,"/Signature_component_heatMap",".tiff"),width = 6,
                    height = 4, units = 'in', res = 300)
    pheatmap::pheatmap(sigs, fontsize = 10, Rowv = NA, Colv = NA, cellwidth = 50, 
                       legend = TRUE, main = plotTitle, color = heatmapColors, 
                       border_color = NA, cluster_rows = FALSE, cluster_cols = FALSE)
    grDevices::dev.off()
  } else {
    pheatmap::pheatmap(sigs, fontsize = 10, Rowv = NA, Colv = NA, cellwidth = 50, 
                       legend = TRUE, main = plotTitle, color = heatmapColors,
                       border_color = NA, cluster_rows = FALSE, cluster_cols = FALSE)
  }
}
