#' plotComps
#'
#' This function plots all of the mixed models so that it can be visualized.
#' It utilizes the gamma function to allow approximations of the poisson
#' distributions, allowing for a smooth plot.
#'
#' @param comps List of components to be plotted. Output from fitModels.
#' @param saveRes Whether or not to save results. Default is F.
#' @param saveDir Where to save plots. Default is getwd()
#' @param runName Used to add a runName to the file output. Default is "".
#' @keywords component plot
#' @import ggplot2
#' @export
#' @return Plots all the components to allow visualization
#' @examples 
#' plotComps(compsExp)
plotComps = function(comps,saveRes=FALSE,saveDir=NULL,runName = ""){
   for (comp in names(comps)){
      plotComp(comps,comp,saveRes,saveDir,runName)
   }
}
