#' Segmentation Data from TCGA BRCA samples
#'
#' A small example subset of BRCA samples from TCGA in list format. Each item
#' contains the segmentation data for that sample.
#'
#' @format A list with 20 elements and 5 variables:
#' \describe{
#'   \item{ID}{ID number for the sample}
#'   \item{chromosome}{chromosome the segment is found on}
#'   \item{start}{starting position of the segment}
#'   \item{end}{end position of the segment}
#'   \item{segVal}{copynumber value for the segment}  
#' }
#' @source \url{https://portal.gdc.cancer.gov/}
"segDataExp"

#' Features from segDataExp
#'
#' The extracted features from the segDataExp dataset. Generated using the 
#' function extractCNFeats(segDataExp). Each data frame has a value and a ID
#' column. The ID tells you which sample the observed value is from.
#'
#' @format A list with 6 data frames:
#' \describe{
#'   \item{segsize}{Size of every segment}
#'   \item{bp10MB}{Average # of breakpoints per 10MB per chromosome}
#'   \item{osCN}{Number of oscillation events per chromosome}
#'   \item{changepoint}{Average changepoint per chromosome}
#'   \item{copynumber}{Average copy number per chromosome}  
#'   \item{bpchrarm}{Number of breakpoints per chromosome arm}
#' }
"featsExp"

#' Components fitted onto featsExp
#'
#' The generated components for the segDataExp dataset. Generated using the 
#' function fitModels(featsExp). Each data frame has a value and a ID
#' column. The ID tells you which sample the observed value is from.
#'
#' @format A list with 6 flexmix objects:
#' \describe{
#'   \item{segsize}{Mixture of normal distributions}
#'   \item{bp10MB}{Mixture of normal distributions}
#'   \item{osCN}{Mixture of poisson distributions}
#'   \item{changepoint}{Mixture of normal distributions}
#'   \item{copynumber}{Mixture of normal distributions}  
#'   \item{bpchrarm}{Mixture of poisson distributions}
#' }
"compsExp"

#' Sample by component matrix for segDataExp
#'
#' The generated scm for the segDataExp dataset. Generated using the 
#' function generateSCM(featsExp,compsExp). It is a matrix showing how much
#' each extracted component contributes to each sample. Is what is put into NMF
#' and used to create the signatures.
"scmExp"

#' The result object from Pipeline using segDataExp.
#' 
#' The generated result object from the entire pipelin using the segDataExp.
#' Function used to create: referenceExp = runPipeline(segDataExp,nsigs = 5)
#'
#' @format A list with 7 elements:
#' \describe{
#'   \item{func}{The function call used in the pipeline run}
#'   \item{Input_data}{The data the features were extracted from}
#'   \item{CN_features}{The extracted features}
#'   \item{CN_components}{The fitted component models}
#'   \item{scm}{The sample by component matrix}  
#'   \item{nmf_Results}{The results of the NMF run}
#'   \item{sigs}{The signature by component matrix.}
#' }
"referenceExp"

#' The generated Signatures from the segDataExp run
#'
#' The generated signature by component matrix for the segDataExp dataset. 
#' Extracted from the referenceExp data object using referenceExp$sigs. 
#' This matrix shows how much each component contributes to the signatures.
"sigsExp"

#' The generated sigExposure from the segDataExp run
#'
#' The generated signature exposure matrix for the segDataExp dataset. 
#' Extracted from the referenceExp data object using referenceExp$sigExposure. 
#' This matrix shows how much each signature contributes to the patient samples.
"sigExposExp"

#' Components derived from TCGA
#'
#' These generated components were derived from all of the copy number data
#' available from TCGA. It is meant to be used to look for signatures in cancer
#' data so that you do not have to model new data, and so that you can easily
#' compare signatures
#'
#' @format A list with 6 flexmix objects:
#' \describe{
#'   \item{segsize}{Mixture of normal distributions}
#'   \item{bp10MB}{Mixture of normal distributions}
#'   \item{osCN}{Mixture of poisson distributions}
#'   \item{changepoint}{Mixture of normal distributions}
#'   \item{copynumber}{Mixture of normal distributions}  
#'   \item{bpchrarm}{Mixture of poisson distributions}
#' }
"cancerComps"

#' Signatures derived from TCGA
#'
#' These signatures were derived from all of the copy number data
#' available from TCGA. It is meant to be used so that you can compare newly
#' found signatures to these described signatures. There are a total of 25
#' signatures. The components used to derive these signatures can be found in
#' the cancerComps variable.
"cancerSigs"

#' Default features to use for copy number signatures
#' 
#' These are the default features that are used in the package. Use this to get
#' a list of the feature names and you can remove values from this and pass it in
#' to the package using the featsToUse parameter seen in multiple functions.
"defaultFeats"

#' Signatures derived from TCGA and collapsed.
#' 
#' These signatures were derived from all of the copy number data
#' available from TCGA. These pan-cancer signatures were collapsed by 
#' similarity to a total of 13 signatures and were built using ploidy data.
#' It is meant to be used so that you can compare newly found
#' signatures to these described signatures.
#' 
"collapsedSigs"

