% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_bayesm_by_predictor.R
\name{compare_bayesm_by_predictor}
\alias{compare_bayesm_by_predictor}
\title{Compare Bayesian Models by Predictor Using Posterior Predictive Simulations}
\usage{
compare_bayesm_by_predictor(
  data,
  models,
  parameters = NULL,
  var.plot,
  intercept = NULL,
  ypredict = NULL,
  outcome,
  mbreaks
)
}
\arguments{
\item{data}{A data frame containing the original dataset.}

\item{models}{A named list of fitted \code{stanfit} model objects. Each name will be used as the model label.}

\item{parameters}{Optional. A \strong{named list} mapping each model to a named character vector where each name is a variable in the data and the value is the name of the corresponding parameter/coefficient in the model.
Must have the same names as \code{models}. Required if \code{ypredict} is not provided.}

\item{var.plot}{A single character string. Name of the predictor variable in \code{data} used for binning and plotting. Must be in all the models.}

\item{intercept}{Optional. A named list with the intercept parameter names for each model. Each entry should be a character string or \code{NULL} if no intercept is used. Must have the same names as \code{models}.}

\item{ypredict}{Optional. A named list of posterior predictive matrices. Each matrix should have rows as posterior draws
and columns as data points. If not provided, predictions are computed internally. Must have the same names as \code{models}.}

\item{outcome}{A character string. The name of the outcome variable in \code{data}.}

\item{mbreaks}{Number of bins if \code{var.plot} is numeric; ignored if it's a factor.}
}
\value{
A list containing:
\describe{
\item{models_summary}{A data frame summarizing the posterior predictive means and standard deviations per draw, model, and predictor level (or bin).}
\item{p_mean}{A \code{ggplot} showing the distribution of simulated outcome means for each bin and model, overlaid with the observed means and sample size per bin.}
\item{p_sd}{A \code{ggplot} showing the distribution of simulated outcome standard deviations for each bin and model, overlaid with the observed standard deviations and sample size per bin.}
}
The function also prints the plots side by side using \code{ggarrange()}.
}
\description{
This function compares posterior predictive distributions from several Bayesian models across levels of a selected predictor variable.
For numeric predictors, the variable is binned; for categorical predictors, the original factor levels are used directly.
The function visualizes the distribution of simulated means and standard deviations per predictor level alongside the observed values.
}
\details{
This function provides a visual diagnostic for comparing posterior predictive summaries across multiple Bayesian models.
The predictor variable can be either continuous or categorical. For continuous variables, the range is divided into bins using \code{cut()} and \code{mbreaks}; for categorical variables, no binning is applied.
Posterior predictive distributions are either precomputed via \code{ypredict} or generated internally using \code{parameters} and (optionally) \code{intercept}.
}
