% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_bayesm.R
\name{compare_bayesm}
\alias{compare_bayesm}
\title{Posterior Predictive Check for Multiple Bayesian Models}
\usage{
compare_bayesm(
  models,
  ypredict = NULL,
  data,
  outcome,
  intercept = NULL,
  var.param = NULL
)
}
\arguments{
\item{models}{A \strong{named list} of fitted \code{rstan} models (objects of class \code{stanfit}).}

\item{ypredict}{Optional. A named list of posterior predictive matrices. Each matrix should have rows as posterior draws
and columns as data points. If not provided, predictions are computed internally. Must have the same names as \code{models}.}

\item{data}{A data frame containing the predictor variables and the outcome used for model prediction.}

\item{outcome}{A character string naming the outcome variable in \code{data}.}

\item{intercept}{(Optional) A named list with the intercept parameter names for each model. Each entry should be a character string or \code{NULL} if no intercept is used. Must have the same names as \code{models}.}

\item{var.param}{A \strong{named list} mapping each model to a named character vector where each name is a variable in the data and the value is the name of the corresponding parameter/coefficient in the model.
Must have the same names as \code{models}. Required if \code{ypredict} is not provided.}
}
\value{
Invisibly returns a list with two ggplot objects:
\describe{
\item{ppc_pe}{A ggplot object showing the distribution of simulated mean of the outcome across models.}
\item{ppc_sd}{A ggplot object showing the distribution of simulated standard deviations of the outcome across models.}
}
}
\description{
This function performs a posterior predictive check for one or more Bayesian models by computing
the mean and standard deviations of simulated predictions, comparing them
to the observed outcome. It produces grouped histograms for each model.
}
